/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.clickgui.components;

import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.wurstclient.clickgui.ClickGui;
import net.wurstclient.clickgui.Component;
import net.wurstclient.clickgui.screens.EditSliderScreen;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.util.RenderUtils;

public final class SliderComponent
extends Component {
    private static final ClickGui GUI = WURST.getGui();
    private static final class_327 TR = SliderComponent.MC.field_1772;
    private static final int TEXT_HEIGHT = 11;
    private final SliderSetting setting;
    private boolean dragging;

    public SliderComponent(SliderSetting setting) {
        this.setting = setting;
        this.setWidth(this.getDefaultWidth());
        this.setHeight(this.getDefaultHeight());
    }

    @Override
    public void handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        if (mouseY < (double)(this.getY() + 11)) {
            return;
        }
        switch (mouseButton) {
            case 0: {
                if (class_437.method_25441()) {
                    MC.method_1507((class_437)new EditSliderScreen(SliderComponent.MC.field_1755, this.setting));
                    break;
                }
                this.dragging = true;
                break;
            }
            case 1: {
                this.setting.setValue(this.setting.getDefaultValue());
            }
        }
    }

    private void handleDragging(int mouseX, int x3, int x4) {
        if (!this.dragging) {
            return;
        }
        if (!GUI.isLeftMouseButtonPressed()) {
            this.dragging = false;
            return;
        }
        double sliderStartX = x3;
        double sliderWidth = x4 - x3;
        double mousePercentage = ((double)mouseX - sliderStartX) / sliderWidth;
        double min = this.setting.getMinimum();
        double range = this.setting.getRange();
        double value = min + range * mousePercentage;
        this.setting.setValue(value);
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float partialTicks) {
        int x1 = this.getX();
        int x2 = x1 + this.getWidth();
        int x3 = x1 + 2;
        int x4 = x2 - 2;
        int y1 = this.getY();
        int y2 = y1 + this.getHeight();
        int y3 = y1 + 11;
        int y4 = y3 + 4;
        int y5 = y2 - 4;
        this.handleDragging(mouseX, x3, x4);
        boolean hovering = this.isHovering(mouseX, mouseY);
        boolean hText = hovering && mouseY < y3;
        boolean hSlider = hovering && mouseY >= y3 || this.dragging;
        boolean grayedOut = this.setting.isDisabled() || this.setting.isLocked();
        float opacity = GUI.getOpacity();
        float railOpacity = opacity * (hSlider ? 1.5f : 1.0f);
        if (hText) {
            GUI.setTooltip(this.getTextTooltip());
        } else if (hSlider && !this.dragging) {
            GUI.setTooltip(this.getSliderTooltip());
        }
        if (grayedOut) {
            hovering = false;
            hSlider = false;
        }
        int bgColor = RenderUtils.toIntColor(GUI.getBgColor(), opacity);
        float[][] bgVertices = new float[][]{{x1, y1}, {x1, y4}, {x2, y4}, {x2, y1}, {x1, y5}, {x1, y2}, {x2, y2}, {x2, y5}, {x1, y4}, {x1, y5}, {x3, y5}, {x3, y4}, {x4, y4}, {x4, y5}, {x2, y5}, {x2, y4}};
        RenderUtils.fillQuads2D(context, bgVertices, bgColor);
        float xl1 = x3;
        float xl2 = x4;
        if (!grayedOut && this.setting.isLimited()) {
            double ratio = (double)(x4 - x3) / this.setting.getRange();
            xl1 = (float)((double)xl1 + ratio * (this.setting.getUsableMin() - this.setting.getMinimum()));
            xl2 = (float)((double)xl2 + ratio * (this.setting.getUsableMax() - this.setting.getMaximum()));
            int limitColor = RenderUtils.toIntColor(new float[]{1.0f, 0.0f, 0.0f}, railOpacity);
            float[][] limitVertices = new float[][]{{x3, y4}, {x3, y5}, {xl1, y5}, {xl1, y4}, {xl2, y4}, {xl2, y5}, {x4, y5}, {x4, y4}};
            RenderUtils.fillQuads2D(context, limitVertices, limitColor);
        }
        RenderUtils.fill2D(context, xl1, y4, xl2, y5, RenderUtils.toIntColor(GUI.getBgColor(), railOpacity));
        RenderUtils.drawBorder2D(context, xl1, y4, xl2, y5, RenderUtils.toIntColor(GUI.getAcColor(), 0.5f));
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416(0.0f, 0.0f, 2.0f);
        float xk1 = (float)x1 + (float)(x2 - x1 - 8) * (float)this.setting.getPercentage();
        float xk2 = xk1 + 8.0f;
        float yk1 = (float)y3 + 1.5f;
        float yk2 = (float)y2 - 1.5f;
        int knobColor = grayedOut ? -1065320320 : RenderUtils.toIntColor(this.setting.getKnobColor(), hSlider ? 1.0f : 0.75f);
        RenderUtils.fill2D(context, xk1, yk1, xk2, yk2, knobColor);
        RenderUtils.drawBorder2D(context, xk1, yk1, xk2, yk2, -2146430960);
        matrices.method_22909();
        String name = this.setting.getName();
        String value = this.setting.getValueString();
        int valueWidth = TR.method_1727(value);
        int txtColor = GUI.getTxtColor();
        context.method_51433(TR, name, x1, y1 + 2, txtColor, false);
        context.method_51433(TR, value, x2 - valueWidth, y1 + 2, txtColor, false);
    }

    private String getTextTooltip() {
        Object tooltip = this.setting.getWrappedDescription(200);
        if (this.setting.isDisabled()) {
            tooltip = (String)tooltip + "\n\nThis slider is disabled.";
        } else if (this.setting.isLocked()) {
            tooltip = (String)tooltip + "\n\nThis slider is locked to ";
            tooltip = (String)tooltip + this.setting.getValueString() + ".";
        }
        return tooltip;
    }

    private String getSliderTooltip() {
        Object tooltip = "\u00a7e[ctrl]\u00a7r+\u00a7e[left-click]\u00a7r for precise input\n";
        tooltip = (String)tooltip + "\u00a7e[right-click]\u00a7r to reset";
        return tooltip;
    }

    @Override
    public int getDefaultWidth() {
        int nameWitdh = TR.method_1727(this.setting.getName());
        int valueWidth = TR.method_1727(this.setting.getValueString());
        return nameWitdh + valueWidth + 6;
    }

    @Override
    public int getDefaultHeight() {
        return 22;
    }
}

