/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import net.minecraft.class_3532;
import net.minecraft.class_7172;
import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.mixinterface.ISimpleOption;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.EnumSetting;
import net.wurstclient.settings.SliderSetting;

@SearchTags(value={"Fullbrightness", "full brightness", "Fulbrightness", "ful brightness", "NightVision", "night vision", "FullLightness", "FulLightness", "full lightness", "FullGamma", "full gamma"})
public final class FullbrightHack
extends Hack
implements UpdateListener {
    private final EnumSetting<Method> method = new EnumSetting("Method", "\u00a7lGamma\u00a7r works by setting your brightness slider beyond 100%. Incompatible with shader packs.\n\n\u00a7lNight Vision\u00a7r works by applying the night vision effect. This \u00a7ousually\u00a7r works with shader packs.", (Enum[])Method.values(), (Enum)Method.GAMMA);
    private final CheckboxSetting fade = new CheckboxSetting("Fade", "Slowly fades between brightness and darkness.", true);
    private final SliderSetting defaultGamma = new SliderSetting("Default brightness", "Fullbright will set your brightness slider back to this value when you turn it off.", 0.5, 0.0, 1.0, 0.01, SliderSetting.ValueDisplay.PERCENTAGE);
    private boolean wasGammaChanged;
    private float nightVisionStrength;

    public FullbrightHack() {
        super("Fullbright");
        this.setCategory(Category.RENDER);
        this.addSetting(this.method);
        this.addSetting(this.fade);
        this.addSetting(this.defaultGamma);
        this.checkGammaOnStartup();
        EVENTS.add(UpdateListener.class, this);
    }

    private void checkGammaOnStartup() {
        EVENTS.add(UpdateListener.class, new UpdateListener(){

            @Override
            public void onUpdate() {
                double gamma = (Double)MC.field_1690.method_42473().method_41753();
                System.out.println("Brightness started at " + gamma);
                if (gamma > 1.0) {
                    FullbrightHack.this.wasGammaChanged = true;
                } else {
                    FullbrightHack.this.defaultGamma.setValue(gamma);
                }
                EVENTS.remove(UpdateListener.class, this);
            }
        });
    }

    @Override
    public void onUpdate() {
        this.updateGamma();
        this.updateNightVision();
    }

    private void updateGamma() {
        if (this.isChangingGamma()) {
            this.setGamma(16.0);
            return;
        }
        if (this.wasGammaChanged) {
            this.resetGamma(this.defaultGamma.getValue());
        }
    }

    private void setGamma(double target) {
        this.wasGammaChanged = true;
        class_7172 gammaOption = FullbrightHack.MC.field_1690.method_42473();
        ISimpleOption<Double> gammaOption2 = ISimpleOption.get(gammaOption);
        double oldGammaValue = (Double)gammaOption.method_41753();
        if (!this.fade.isChecked() || Math.abs(oldGammaValue - target) <= 0.5) {
            gammaOption2.forceSetValue(target);
            return;
        }
        if (oldGammaValue < target) {
            gammaOption2.forceSetValue(oldGammaValue + 0.5);
        } else {
            gammaOption2.forceSetValue(oldGammaValue - 0.5);
        }
    }

    private void resetGamma(double target) {
        class_7172 gammaOption = FullbrightHack.MC.field_1690.method_42473();
        ISimpleOption<Double> gammaOption2 = ISimpleOption.get(gammaOption);
        double oldGammaValue = (Double)gammaOption.method_41753();
        if (!this.fade.isChecked() || Math.abs(oldGammaValue - target) <= 0.5) {
            gammaOption2.forceSetValue(target);
            this.wasGammaChanged = false;
            return;
        }
        if (oldGammaValue < target) {
            gammaOption2.forceSetValue(oldGammaValue + 0.5);
        } else {
            gammaOption2.forceSetValue(oldGammaValue - 0.5);
        }
    }

    private void updateNightVision() {
        boolean shouldGiveNightVision;
        boolean bl = shouldGiveNightVision = this.isEnabled() && this.method.getSelected() == Method.NIGHT_VISION;
        if (this.fade.isChecked()) {
            this.nightVisionStrength = shouldGiveNightVision ? (float)((double)this.nightVisionStrength + 0.03125) : (float)((double)this.nightVisionStrength - 0.03125);
            this.nightVisionStrength = class_3532.method_15363((float)this.nightVisionStrength, (float)0.0f, (float)1.0f);
        } else {
            this.nightVisionStrength = shouldGiveNightVision ? 1.0f : 0.0f;
        }
    }

    public boolean isNightVisionActive() {
        return this.nightVisionStrength > 0.0f;
    }

    public float getNightVisionStrength() {
        return this.nightVisionStrength;
    }

    public boolean isChangingGamma() {
        return this.isEnabled() && this.method.getSelected() == Method.GAMMA;
    }

    public double getDefaultGamma() {
        return this.defaultGamma.getValue();
    }

    private static enum Method {
        GAMMA("Gamma"),
        NIGHT_VISION("Night Vision");

        private final String name;

        private Method(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

