/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.test;

import java.time.Duration;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_155;
import net.minecraft.class_442;
import net.minecraft.class_525;
import net.minecraft.class_526;
import net.minecraft.class_8032;
import net.wurstclient.test.AltManagerTest;
import net.wurstclient.test.AutoMineHackTest;
import net.wurstclient.test.CopyItemCmdTest;
import net.wurstclient.test.FreecamHackTest;
import net.wurstclient.test.GiveCmdTest;
import net.wurstclient.test.ModifyCmdTest;
import net.wurstclient.test.NoFallHackTest;
import net.wurstclient.test.PistonTest;
import net.wurstclient.test.WurstClientTestHelper;
import net.wurstclient.test.XRayHackTest;
import org.spongepowered.asm.mixin.MixinEnvironment;

public final class WurstE2ETestClient
implements ModInitializer {
    public void onInitialize() {
        if (System.getProperty("wurst.e2eTest") == null) {
            return;
        }
        Thread.ofVirtual().name("Wurst End-to-End Test").uncaughtExceptionHandler((t, e) -> {
            e.printStackTrace();
            System.exit(1);
        }).start(this::runTests);
    }

    private void runTests() {
        System.out.println("Starting Wurst End-to-End Tests");
        WurstClientTestHelper.waitForResourceLoading();
        if (WurstClientTestHelper.submitAndGet(mc -> mc.field_1690.field_41785).booleanValue()) {
            System.out.println("Onboarding is enabled. Waiting for it");
            WurstClientTestHelper.waitForScreen(class_8032.class);
            System.out.println("Reached onboarding screen");
            WurstClientTestHelper.clickButton("gui.continue");
        }
        WurstClientTestHelper.waitForScreen(class_442.class);
        WurstClientTestHelper.waitForTitleScreenFade();
        System.out.println("Reached title screen");
        WurstClientTestHelper.takeScreenshot("title_screen", Duration.ZERO);
        WurstClientTestHelper.submitAndWait(AltManagerTest::testAltManagerButton);
        System.out.println("Clicking singleplayer button");
        WurstClientTestHelper.clickButton("menu.singleplayer");
        if (WurstClientTestHelper.submitAndGet(mc -> !mc.method_1586().method_235().method_43421()).booleanValue()) {
            System.out.println("World list is not empty. Waiting for it");
            WurstClientTestHelper.waitForScreen(class_526.class);
            System.out.println("Reached select world screen");
            WurstClientTestHelper.takeScreenshot("select_world_screen");
            WurstClientTestHelper.clickButton("selectWorld.create");
        }
        WurstClientTestHelper.waitForScreen(class_525.class);
        System.out.println("Reached create world screen");
        WurstClientTestHelper.setTextFieldText(0, "E2E Test " + class_155.method_16673().method_48019());
        WurstClientTestHelper.clickButton("selectWorld.gameMode");
        WurstClientTestHelper.clickButton("selectWorld.gameMode");
        WurstClientTestHelper.takeScreenshot("create_world_screen");
        System.out.println("Creating test world");
        WurstClientTestHelper.clickButton("selectWorld.create");
        WurstClientTestHelper.waitForWorldLoad();
        WurstClientTestHelper.dismissTutorialToasts();
        WurstClientTestHelper.waitForWorldTicks(200);
        WurstClientTestHelper.runChatCommand("seed");
        System.out.println("Reached singleplayer world");
        WurstClientTestHelper.takeScreenshot("in_game", Duration.ZERO);
        WurstClientTestHelper.clearChat();
        System.out.println("Opening debug menu");
        WurstClientTestHelper.toggleDebugHud();
        WurstClientTestHelper.takeScreenshot("debug_menu");
        System.out.println("Closing debug menu");
        WurstClientTestHelper.toggleDebugHud();
        System.out.println("Checking for broken mixins");
        MixinEnvironment.getCurrentEnvironment().audit();
        System.out.println("Opening inventory");
        WurstClientTestHelper.openInventory();
        WurstClientTestHelper.takeScreenshot("inventory");
        System.out.println("Closing inventory");
        WurstClientTestHelper.closeScreen();
        WurstClientTestHelper.runChatCommand("fill ~-7 ~-5 ~-7 ~7 ~-1 ~7 stone");
        WurstClientTestHelper.runChatCommand("fill ~-7 ~ ~-7 ~7 ~30 ~7 air");
        WurstClientTestHelper.runChatCommand("kill @e[type=!player,distance=..10]");
        WurstClientTestHelper.runChatCommand("clear");
        WurstClientTestHelper.clearChat();
        AutoMineHackTest.testAutoMineHack();
        FreecamHackTest.testFreecamHack();
        NoFallHackTest.testNoFallHack();
        XRayHackTest.testXRayHack();
        CopyItemCmdTest.testCopyItemCmd();
        GiveCmdTest.testGiveCmd();
        ModifyCmdTest.testModifyCmd();
        PistonTest.testPistonDoesntCrash();
        System.out.println("Opening game menu");
        WurstClientTestHelper.openGameMenu();
        WurstClientTestHelper.takeScreenshot("game_menu");
        System.out.println("Returning to title screen");
        WurstClientTestHelper.clickButton("menu.returnToMenu");
        WurstClientTestHelper.waitForScreen(class_442.class);
        System.out.println("Stopping the game");
        WurstClientTestHelper.clickButton("menu.quit");
    }
}

