/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2791;
import net.minecraft.class_308;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5498;
import net.wurstclient.WurstClient;
import net.wurstclient.WurstRenderLayers;
import net.wurstclient.util.RegionPos;
import net.wurstclient.util.RotationUtils;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class RenderUtils
extends Enum<RenderUtils> {
    private static final /* synthetic */ RenderUtils[] $VALUES;

    public static RenderUtils[] values() {
        return (RenderUtils[])$VALUES.clone();
    }

    public static RenderUtils valueOf(String name) {
        return Enum.valueOf(RenderUtils.class, name);
    }

    public static void applyRegionalRenderOffset(class_4587 matrixStack) {
        RenderUtils.applyRegionalRenderOffset(matrixStack, RenderUtils.getCameraRegion());
    }

    public static void applyRegionalRenderOffset(class_4587 matrixStack, class_2791 chunk) {
        RenderUtils.applyRegionalRenderOffset(matrixStack, RegionPos.of(chunk.method_12004()));
    }

    public static void applyRegionalRenderOffset(class_4587 matrixStack, RegionPos region) {
        class_243 offset = region.toVec3d().method_1020(RenderUtils.getCameraPos());
        matrixStack.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
    }

    public static void applyRenderOffset(class_4587 matrixStack) {
        class_243 camPos = RenderUtils.getCameraPos();
        matrixStack.method_22904(-camPos.field_1352, -camPos.field_1351, -camPos.field_1350);
    }

    public static class_243 getCameraPos() {
        class_4184 camera = WurstClient.MC.method_31975().field_4344;
        if (camera == null) {
            return class_243.field_1353;
        }
        return camera.method_19326();
    }

    public static class_2338 getCameraBlockPos() {
        class_4184 camera = WurstClient.MC.method_31975().field_4344;
        if (camera == null) {
            return class_2338.field_10980;
        }
        return camera.method_19328();
    }

    public static RegionPos getCameraRegion() {
        return RegionPos.of(RenderUtils.getCameraBlockPos());
    }

    public static class_4597.class_4598 getVCP() {
        return WurstClient.MC.method_22940().method_23000();
    }

    public static float[] getRainbowColor() {
        float x = (float)(System.currentTimeMillis() % 2000L) / 1000.0f;
        float pi = (float)Math.PI;
        float[] rainbow = new float[]{0.5f + 0.5f * class_3532.method_15374((float)(x * pi)), 0.5f + 0.5f * class_3532.method_15374((float)((x + 1.3333334f) * pi)), 0.5f + 0.5f * class_3532.method_15374((float)((x + 2.6666667f) * pi))};
        return rainbow;
    }

    public static void setShaderColor(float[] rgb, float opacity) {
        RenderSystem.setShaderColor((float)rgb[0], (float)rgb[1], (float)rgb[2], (float)opacity);
    }

    public static int toIntColor(float[] rgb, float opacity) {
        return (int)(class_3532.method_15363((float)opacity, (float)0.0f, (float)1.0f) * 255.0f) << 24 | (int)(class_3532.method_15363((float)rgb[0], (float)0.0f, (float)1.0f) * 255.0f) << 16 | (int)(class_3532.method_15363((float)rgb[1], (float)0.0f, (float)1.0f) * 255.0f) << 8 | (int)(class_3532.method_15363((float)rgb[2], (float)0.0f, (float)1.0f) * 255.0f);
    }

    public static void drawLine(class_4587 matrices, class_243 start, class_243 end, int color, boolean depthTest) {
        int depthFunc = depthTest ? 515 : 519;
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)depthFunc);
        class_4597.class_4598 vcp = RenderUtils.getVCP();
        class_1921 layer = WurstRenderLayers.getLines(depthTest);
        class_4588 buffer = vcp.getBuffer(layer);
        class_243 offset = RenderUtils.getCameraPos().method_22882();
        RenderUtils.drawLine(matrices, buffer, start.method_1019(offset), end.method_1019(offset), color);
        vcp.method_22994(layer);
    }

    private static class_243 getTracerOrigin(float partialTicks) {
        class_243 start = RotationUtils.getClientLookVec(partialTicks);
        if (WurstClient.MC.field_1690.method_31044() == class_5498.field_26666) {
            start = start.method_22882();
        }
        return start;
    }

    public static void drawTracer(class_4587 matrices, float partialTicks, class_243 end, int color, boolean depthTest) {
        int depthFunc = depthTest ? 515 : 519;
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)depthFunc);
        class_4597.class_4598 vcp = RenderUtils.getVCP();
        class_1921 layer = WurstRenderLayers.getLines(depthTest);
        class_4588 buffer = vcp.getBuffer(layer);
        class_243 start = RenderUtils.getTracerOrigin(partialTicks);
        class_243 offset = RenderUtils.getCameraPos().method_22882();
        RenderUtils.drawLine(matrices, buffer, start, end.method_1019(offset), color);
        vcp.method_22994(layer);
    }

    public static void drawTracers(class_4587 matrices, float partialTicks, List<class_243> ends, int color, boolean depthTest) {
        int depthFunc = depthTest ? 515 : 519;
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)depthFunc);
        class_4597.class_4598 vcp = RenderUtils.getVCP();
        class_1921 layer = WurstRenderLayers.getLines(depthTest);
        class_4588 buffer = vcp.getBuffer(layer);
        class_243 start = RenderUtils.getTracerOrigin(partialTicks);
        class_243 offset = RenderUtils.getCameraPos().method_22882();
        for (class_243 end : ends) {
            RenderUtils.drawLine(matrices, buffer, start, end.method_1019(offset), color);
        }
        vcp.method_22994(layer);
    }

    public static void drawTracers(class_4587 matrices, float partialTicks, List<ColoredPoint> ends, boolean depthTest) {
        int depthFunc = depthTest ? 515 : 519;
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)depthFunc);
        class_4597.class_4598 vcp = RenderUtils.getVCP();
        class_1921 layer = WurstRenderLayers.getLines(depthTest);
        class_4588 buffer = vcp.getBuffer(layer);
        class_243 start = RenderUtils.getTracerOrigin(partialTicks);
        class_243 offset = RenderUtils.getCameraPos().method_22882();
        for (ColoredPoint end : ends) {
            RenderUtils.drawLine(matrices, buffer, start, end.point().method_1019(offset), end.color());
        }
        vcp.method_22994(layer);
    }

    public static void drawLine(class_4587 matrices, class_4588 buffer, class_243 start, class_243 end, int color) {
        class_4587.class_4665 entry = matrices.method_23760();
        float x1 = (float)start.field_1352;
        float y1 = (float)start.field_1351;
        float z1 = (float)start.field_1350;
        float x2 = (float)end.field_1352;
        float y2 = (float)end.field_1351;
        float z2 = (float)end.field_1350;
        RenderUtils.drawLine(entry, buffer, x1, y1, z1, x2, y2, z2, color);
    }

    public static void drawLine(class_4587.class_4665 entry, class_4588 buffer, float x1, float y1, float z1, float x2, float y2, float z2, int color) {
        Vector3f normal = new Vector3f(x2, y2, z2).sub(x1, y1, z1).normalize();
        buffer.method_56824(entry, x1, y1, z1).method_39415(color).method_61959(entry, normal);
        buffer.method_56824(entry, x2, y2, z2).method_39415(color).method_61959(entry, normal);
    }

    public static void drawLine(class_4588 buffer, float x1, float y1, float z1, float x2, float y2, float z2, int color) {
        Vector3f n = new Vector3f(x2, y2, z2).sub(x1, y1, z1).normalize();
        buffer.method_22912(x1, y1, z1).method_39415(color).method_22914(n.x, n.y, n.z);
        buffer.method_22912(x2, y2, z2).method_39415(color).method_22914(n.x, n.y, n.z);
    }

    public static void drawCurvedLine(class_4587 matrices, List<class_243> points, int color, boolean depthTest) {
        int depthFunc = depthTest ? 515 : 519;
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)depthFunc);
        class_4597.class_4598 vcp = RenderUtils.getVCP();
        class_1921 layer = WurstRenderLayers.getLineStrip(depthTest);
        class_4588 buffer = vcp.getBuffer(layer);
        class_243 offset = RenderUtils.getCameraPos().method_22882();
        List<class_243> points2 = points.stream().map(v -> v.method_1019(offset)).toList();
        RenderUtils.drawCurvedLine(matrices, buffer, points2, color);
        vcp.method_22994(layer);
    }

    public static void drawCurvedLine(class_4587 matrices, class_4588 buffer, List<class_243> points, int color) {
        if (points.size() < 2) {
            return;
        }
        class_4587.class_4665 entry = matrices.method_23760();
        Vector3f first = points.get(0).method_46409();
        Vector3f second = points.get(1).method_46409();
        Vector3f normal = new Vector3f((Vector3fc)first).sub((Vector3fc)second).normalize();
        buffer.method_61032(entry, first).method_39415(color).method_61959(entry, normal);
        for (int i = 1; i < points.size(); ++i) {
            Vector3f prev = points.get(i - 1).method_46409();
            Vector3f current = points.get(i).method_46409();
            normal = new Vector3f((Vector3fc)current).sub((Vector3fc)prev).normalize();
            buffer.method_61032(entry, current).method_39415(color).method_61959(entry, normal);
        }
    }

    public static void drawSolidBox(class_4587 matrices, class_238 box, int color, boolean depthTest) {
        int depthFunc = depthTest ? 515 : 519;
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)depthFunc);
        class_4597.class_4598 vcp = RenderUtils.getVCP();
        class_1921 layer = WurstRenderLayers.getQuads(depthTest);
        class_4588 buffer = vcp.getBuffer(layer);
        RenderUtils.drawSolidBox(matrices, buffer, box.method_997(RenderUtils.getCameraPos().method_22882()), color);
        vcp.method_22994(layer);
    }

    public static void drawSolidBoxes(class_4587 matrices, List<class_238> boxes, int color, boolean depthTest) {
        int depthFunc = depthTest ? 515 : 519;
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)depthFunc);
        class_4597.class_4598 vcp = RenderUtils.getVCP();
        class_1921 layer = WurstRenderLayers.getQuads(depthTest);
        class_4588 buffer = vcp.getBuffer(layer);
        class_243 camOffset = RenderUtils.getCameraPos().method_22882();
        for (class_238 box : boxes) {
            RenderUtils.drawSolidBox(matrices, buffer, box.method_997(camOffset), color);
        }
        vcp.method_22994(layer);
    }

    public static void drawSolidBoxes(class_4587 matrices, List<ColoredBox> boxes, boolean depthTest) {
        int depthFunc = depthTest ? 515 : 519;
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)depthFunc);
        class_4597.class_4598 vcp = RenderUtils.getVCP();
        class_1921 layer = WurstRenderLayers.getQuads(depthTest);
        class_4588 buffer = vcp.getBuffer(layer);
        class_243 camOffset = RenderUtils.getCameraPos().method_22882();
        for (ColoredBox box : boxes) {
            RenderUtils.drawSolidBox(matrices, buffer, box.box().method_997(camOffset), box.color());
        }
        vcp.method_22994(layer);
    }

    public static void drawSolidBox(class_4588 buffer, class_238 box, int color) {
        RenderUtils.drawSolidBox(new class_4587(), buffer, box, color);
    }

    public static void drawSolidBox(class_4587 matrices, class_4588 buffer, class_238 box, int color) {
        class_4587.class_4665 entry = matrices.method_23760();
        float x1 = (float)box.field_1323;
        float y1 = (float)box.field_1322;
        float z1 = (float)box.field_1321;
        float x2 = (float)box.field_1320;
        float y2 = (float)box.field_1325;
        float z2 = (float)box.field_1324;
        buffer.method_56824(entry, x1, y1, z1).method_39415(color);
        buffer.method_56824(entry, x2, y1, z1).method_39415(color);
        buffer.method_56824(entry, x2, y1, z2).method_39415(color);
        buffer.method_56824(entry, x1, y1, z2).method_39415(color);
        buffer.method_56824(entry, x1, y2, z1).method_39415(color);
        buffer.method_56824(entry, x1, y2, z2).method_39415(color);
        buffer.method_56824(entry, x2, y2, z2).method_39415(color);
        buffer.method_56824(entry, x2, y2, z1).method_39415(color);
        buffer.method_56824(entry, x1, y1, z1).method_39415(color);
        buffer.method_56824(entry, x1, y2, z1).method_39415(color);
        buffer.method_56824(entry, x2, y2, z1).method_39415(color);
        buffer.method_56824(entry, x2, y1, z1).method_39415(color);
        buffer.method_56824(entry, x2, y1, z1).method_39415(color);
        buffer.method_56824(entry, x2, y2, z1).method_39415(color);
        buffer.method_56824(entry, x2, y2, z2).method_39415(color);
        buffer.method_56824(entry, x2, y1, z2).method_39415(color);
        buffer.method_56824(entry, x1, y1, z2).method_39415(color);
        buffer.method_56824(entry, x2, y1, z2).method_39415(color);
        buffer.method_56824(entry, x2, y2, z2).method_39415(color);
        buffer.method_56824(entry, x1, y2, z2).method_39415(color);
        buffer.method_56824(entry, x1, y1, z1).method_39415(color);
        buffer.method_56824(entry, x1, y1, z2).method_39415(color);
        buffer.method_56824(entry, x1, y2, z2).method_39415(color);
        buffer.method_56824(entry, x1, y2, z1).method_39415(color);
    }

    public static void drawOutlinedBox(class_4587 matrices, class_238 box, int color, boolean depthTest) {
        int depthFunc = depthTest ? 515 : 519;
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)depthFunc);
        class_4597.class_4598 vcp = RenderUtils.getVCP();
        class_1921 layer = WurstRenderLayers.getLines(depthTest);
        class_4588 buffer = vcp.getBuffer(layer);
        RenderUtils.drawOutlinedBox(matrices, buffer, box.method_997(RenderUtils.getCameraPos().method_22882()), color);
        vcp.method_22994(layer);
    }

    public static void drawOutlinedBoxes(class_4587 matrices, List<class_238> boxes, int color, boolean depthTest) {
        int depthFunc = depthTest ? 515 : 519;
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)depthFunc);
        class_4597.class_4598 vcp = RenderUtils.getVCP();
        class_1921 layer = WurstRenderLayers.getLines(depthTest);
        class_4588 buffer = vcp.getBuffer(layer);
        class_243 camOffset = RenderUtils.getCameraPos().method_22882();
        for (class_238 box : boxes) {
            RenderUtils.drawOutlinedBox(matrices, buffer, box.method_997(camOffset), color);
        }
        vcp.method_22994(layer);
    }

    public static void drawOutlinedBoxes(class_4587 matrices, List<ColoredBox> boxes, boolean depthTest) {
        int depthFunc = depthTest ? 515 : 519;
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)depthFunc);
        class_4597.class_4598 vcp = RenderUtils.getVCP();
        class_1921 layer = WurstRenderLayers.getLines(depthTest);
        class_4588 buffer = vcp.getBuffer(layer);
        class_243 camOffset = RenderUtils.getCameraPos().method_22882();
        for (ColoredBox box : boxes) {
            RenderUtils.drawOutlinedBox(matrices, buffer, box.box().method_997(camOffset), box.color());
        }
        vcp.method_22994(layer);
    }

    public static void drawOutlinedBox(class_4588 buffer, class_238 box, int color) {
        RenderUtils.drawOutlinedBox(new class_4587(), buffer, box, color);
    }

    public static void drawOutlinedBox(class_4587 matrices, class_4588 buffer, class_238 box, int color) {
        class_4587.class_4665 entry = matrices.method_23760();
        float x1 = (float)box.field_1323;
        float y1 = (float)box.field_1322;
        float z1 = (float)box.field_1321;
        float x2 = (float)box.field_1320;
        float y2 = (float)box.field_1325;
        float z2 = (float)box.field_1324;
        buffer.method_56824(entry, x1, y1, z1).method_39415(color).method_60831(entry, 1.0f, 0.0f, 0.0f);
        buffer.method_56824(entry, x2, y1, z1).method_39415(color).method_60831(entry, 1.0f, 0.0f, 0.0f);
        buffer.method_56824(entry, x1, y1, z1).method_39415(color).method_60831(entry, 0.0f, 0.0f, 1.0f);
        buffer.method_56824(entry, x1, y1, z2).method_39415(color).method_60831(entry, 0.0f, 0.0f, 1.0f);
        buffer.method_56824(entry, x2, y1, z1).method_39415(color).method_60831(entry, 0.0f, 0.0f, 1.0f);
        buffer.method_56824(entry, x2, y1, z2).method_39415(color).method_60831(entry, 0.0f, 0.0f, 1.0f);
        buffer.method_56824(entry, x1, y1, z2).method_39415(color).method_60831(entry, 1.0f, 0.0f, 0.0f);
        buffer.method_56824(entry, x2, y1, z2).method_39415(color).method_60831(entry, 1.0f, 0.0f, 0.0f);
        buffer.method_56824(entry, x1, y2, z1).method_39415(color).method_60831(entry, 1.0f, 0.0f, 0.0f);
        buffer.method_56824(entry, x2, y2, z1).method_39415(color).method_60831(entry, 1.0f, 0.0f, 0.0f);
        buffer.method_56824(entry, x1, y2, z1).method_39415(color).method_60831(entry, 0.0f, 0.0f, 1.0f);
        buffer.method_56824(entry, x1, y2, z2).method_39415(color).method_60831(entry, 0.0f, 0.0f, 1.0f);
        buffer.method_56824(entry, x2, y2, z1).method_39415(color).method_60831(entry, 0.0f, 0.0f, 1.0f);
        buffer.method_56824(entry, x2, y2, z2).method_39415(color).method_60831(entry, 0.0f, 0.0f, 1.0f);
        buffer.method_56824(entry, x1, y2, z2).method_39415(color).method_60831(entry, 1.0f, 0.0f, 0.0f);
        buffer.method_56824(entry, x2, y2, z2).method_39415(color).method_60831(entry, 1.0f, 0.0f, 0.0f);
        buffer.method_56824(entry, x1, y1, z1).method_39415(color).method_60831(entry, 0.0f, 1.0f, 0.0f);
        buffer.method_56824(entry, x1, y2, z1).method_39415(color).method_60831(entry, 0.0f, 1.0f, 0.0f);
        buffer.method_56824(entry, x2, y1, z1).method_39415(color).method_60831(entry, 0.0f, 1.0f, 0.0f);
        buffer.method_56824(entry, x2, y2, z1).method_39415(color).method_60831(entry, 0.0f, 1.0f, 0.0f);
        buffer.method_56824(entry, x1, y1, z2).method_39415(color).method_60831(entry, 0.0f, 1.0f, 0.0f);
        buffer.method_56824(entry, x1, y2, z2).method_39415(color).method_60831(entry, 0.0f, 1.0f, 0.0f);
        buffer.method_56824(entry, x2, y1, z2).method_39415(color).method_60831(entry, 0.0f, 1.0f, 0.0f);
        buffer.method_56824(entry, x2, y2, z2).method_39415(color).method_60831(entry, 0.0f, 1.0f, 0.0f);
    }

    public static void drawCrossBox(class_4587 matrices, class_238 box, int color, boolean depthTest) {
        int depthFunc = depthTest ? 515 : 519;
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)depthFunc);
        class_4597.class_4598 vcp = RenderUtils.getVCP();
        class_1921 layer = WurstRenderLayers.getLines(depthTest);
        class_4588 buffer = vcp.getBuffer(layer);
        RenderUtils.drawCrossBox(matrices, buffer, box.method_997(RenderUtils.getCameraPos().method_22882()), color);
        vcp.method_22994(layer);
    }

    public static void drawCrossBoxes(class_4587 matrices, List<class_238> boxes, int color, boolean depthTest) {
        int depthFunc = depthTest ? 515 : 519;
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)depthFunc);
        class_4597.class_4598 vcp = RenderUtils.getVCP();
        class_1921 layer = WurstRenderLayers.getLines(depthTest);
        class_4588 buffer = vcp.getBuffer(layer);
        class_243 camOffset = RenderUtils.getCameraPos().method_22882();
        for (class_238 box : boxes) {
            RenderUtils.drawCrossBox(matrices, buffer, box.method_997(camOffset), color);
        }
        vcp.method_22994(layer);
    }

    public static void drawCrossBoxes(class_4587 matrices, List<ColoredBox> boxes, boolean depthTest) {
        int depthFunc = depthTest ? 515 : 519;
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)depthFunc);
        class_4597.class_4598 vcp = RenderUtils.getVCP();
        class_1921 layer = WurstRenderLayers.getLines(depthTest);
        class_4588 buffer = vcp.getBuffer(layer);
        class_243 camOffset = RenderUtils.getCameraPos().method_22882();
        for (ColoredBox box : boxes) {
            RenderUtils.drawCrossBox(matrices, buffer, box.box().method_997(camOffset), box.color());
        }
        vcp.method_22994(layer);
    }

    public static void drawCrossBox(class_4588 buffer, class_238 box, int color) {
        RenderUtils.drawCrossBox(new class_4587(), buffer, box, color);
    }

    public static void drawCrossBox(class_4587 matrices, class_4588 buffer, class_238 box, int color) {
        class_4587.class_4665 entry = matrices.method_23760();
        float x1 = (float)box.field_1323;
        float y1 = (float)box.field_1322;
        float z1 = (float)box.field_1321;
        float x2 = (float)box.field_1320;
        float y2 = (float)box.field_1325;
        float z2 = (float)box.field_1324;
        buffer.method_56824(entry, x1, y1, z1).method_39415(color).method_60831(entry, 1.0f, 1.0f, 0.0f);
        buffer.method_56824(entry, x2, y2, z1).method_39415(color).method_60831(entry, 1.0f, 1.0f, 0.0f);
        buffer.method_56824(entry, x2, y1, z1).method_39415(color).method_60831(entry, -1.0f, 1.0f, 0.0f);
        buffer.method_56824(entry, x1, y2, z1).method_39415(color).method_60831(entry, -1.0f, 1.0f, 0.0f);
        buffer.method_56824(entry, x2, y1, z1).method_39415(color).method_60831(entry, 0.0f, 1.0f, 1.0f);
        buffer.method_56824(entry, x2, y2, z2).method_39415(color).method_60831(entry, 0.0f, 1.0f, 1.0f);
        buffer.method_56824(entry, x2, y1, z2).method_39415(color).method_60831(entry, 0.0f, 1.0f, -1.0f);
        buffer.method_56824(entry, x2, y2, z1).method_39415(color).method_60831(entry, 0.0f, 1.0f, -1.0f);
        buffer.method_56824(entry, x2, y1, z2).method_39415(color).method_60831(entry, -1.0f, 1.0f, 0.0f);
        buffer.method_56824(entry, x1, y2, z2).method_39415(color).method_60831(entry, -1.0f, 1.0f, 0.0f);
        buffer.method_56824(entry, x1, y1, z2).method_39415(color).method_60831(entry, 1.0f, 1.0f, 0.0f);
        buffer.method_56824(entry, x2, y2, z2).method_39415(color).method_60831(entry, 1.0f, 1.0f, 0.0f);
        buffer.method_56824(entry, x1, y1, z2).method_39415(color).method_60831(entry, 0.0f, 1.0f, -1.0f);
        buffer.method_56824(entry, x1, y2, z1).method_39415(color).method_60831(entry, 0.0f, 1.0f, -1.0f);
        buffer.method_56824(entry, x1, y1, z1).method_39415(color).method_60831(entry, 0.0f, 1.0f, 1.0f);
        buffer.method_56824(entry, x1, y2, z2).method_39415(color).method_60831(entry, 0.0f, 1.0f, 1.0f);
        buffer.method_56824(entry, x1, y2, z2).method_39415(color).method_60831(entry, 1.0f, 0.0f, -1.0f);
        buffer.method_56824(entry, x2, y2, z1).method_39415(color).method_60831(entry, 1.0f, 0.0f, -1.0f);
        buffer.method_56824(entry, x1, y2, z1).method_39415(color).method_60831(entry, 1.0f, 0.0f, 1.0f);
        buffer.method_56824(entry, x2, y2, z2).method_39415(color).method_60831(entry, 1.0f, 0.0f, 1.0f);
        buffer.method_56824(entry, x2, y1, z1).method_39415(color).method_60831(entry, -1.0f, 0.0f, 1.0f);
        buffer.method_56824(entry, x1, y1, z2).method_39415(color).method_60831(entry, -1.0f, 0.0f, 1.0f);
        buffer.method_56824(entry, x1, y1, z1).method_39415(color).method_60831(entry, 1.0f, 0.0f, 1.0f);
        buffer.method_56824(entry, x2, y1, z2).method_39415(color).method_60831(entry, 1.0f, 0.0f, 1.0f);
    }

    public static void drawNode(class_4587 matrices, class_238 box, int color, boolean depthTest) {
        int depthFunc = depthTest ? 515 : 519;
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)depthFunc);
        class_4597.class_4598 vcp = RenderUtils.getVCP();
        class_1921 layer = WurstRenderLayers.getLines(depthTest);
        class_4588 buffer = vcp.getBuffer(layer);
        RenderUtils.drawNode(matrices, buffer, box.method_997(RenderUtils.getCameraPos().method_22882()), color);
        vcp.method_22994(layer);
    }

    public static void drawNode(class_4588 buffer, class_238 box, int color) {
        RenderUtils.drawNode(new class_4587(), buffer, box, color);
    }

    public static void drawNode(class_4587 matrices, class_4588 buffer, class_238 box, int color) {
        class_4587.class_4665 entry = matrices.method_23760();
        float x1 = (float)box.field_1323;
        float y1 = (float)box.field_1322;
        float z1 = (float)box.field_1321;
        float x2 = (float)box.field_1320;
        float y2 = (float)box.field_1325;
        float z2 = (float)box.field_1324;
        float x3 = (x1 + x2) / 2.0f;
        float y3 = (y1 + y2) / 2.0f;
        float z3 = (z1 + z2) / 2.0f;
        RenderUtils.drawLine(entry, buffer, x3, y3, z2, x1, y3, z3, color);
        RenderUtils.drawLine(entry, buffer, x1, y3, z3, x3, y3, z1, color);
        RenderUtils.drawLine(entry, buffer, x3, y3, z1, x2, y3, z3, color);
        RenderUtils.drawLine(entry, buffer, x2, y3, z3, x3, y3, z2, color);
        RenderUtils.drawLine(entry, buffer, x3, y2, z3, x2, y3, z3, color);
        RenderUtils.drawLine(entry, buffer, x3, y2, z3, x1, y3, z3, color);
        RenderUtils.drawLine(entry, buffer, x3, y2, z3, x3, y3, z1, color);
        RenderUtils.drawLine(entry, buffer, x3, y2, z3, x3, y3, z2, color);
        RenderUtils.drawLine(entry, buffer, x3, y1, z3, x2, y3, z3, color);
        RenderUtils.drawLine(entry, buffer, x3, y1, z3, x1, y3, z3, color);
        RenderUtils.drawLine(entry, buffer, x3, y1, z3, x3, y3, z1, color);
        RenderUtils.drawLine(entry, buffer, x3, y1, z3, x3, y3, z2, color);
    }

    public static void drawArrow(class_4587 matrices, class_4588 buffer, class_2338 from, class_2338 to, RegionPos region, int color) {
        class_243 fromVec = from.method_46558().method_1023((double)region.x(), 0.0, (double)region.z());
        class_243 toVec = to.method_46558().method_1023((double)region.x(), 0.0, (double)region.z());
        RenderUtils.drawArrow(matrices, buffer, fromVec, toVec, color, 0.0625f);
    }

    public static void drawArrow(class_4588 buffer, class_243 from, class_243 to, int color, float headSize) {
        RenderUtils.drawArrow(new class_4587(), buffer, from, to, color, headSize);
    }

    public static void drawArrow(class_4587 matrices, class_4588 buffer, class_243 from, class_243 to, int color, float headSize) {
        matrices.method_22903();
        class_4587.class_4665 entry = matrices.method_23760();
        Matrix4f matrix = entry.method_23761();
        RenderUtils.drawLine(matrices, buffer, from, to, color);
        matrices.method_61958(to);
        matrices.method_22905(headSize, headSize, headSize);
        double xDiff = to.field_1352 - from.field_1352;
        double yDiff = to.field_1351 - from.field_1351;
        double zDiff = to.field_1350 - from.field_1350;
        float xAngle = (float)(Math.atan2(yDiff, -zDiff) + Math.toRadians(90.0));
        matrix.rotate(xAngle, (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f));
        double yzDiff = Math.sqrt(yDiff * yDiff + zDiff * zDiff);
        float zAngle = (float)Math.atan2(xDiff, yzDiff);
        matrix.rotate(zAngle, (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f));
        RenderUtils.drawLine(entry, buffer, 0.0f, 2.0f, 1.0f, -1.0f, 2.0f, 0.0f, color);
        RenderUtils.drawLine(entry, buffer, -1.0f, 2.0f, 0.0f, 0.0f, 2.0f, -1.0f, color);
        RenderUtils.drawLine(entry, buffer, 0.0f, 2.0f, -1.0f, 1.0f, 2.0f, 0.0f, color);
        RenderUtils.drawLine(entry, buffer, 1.0f, 2.0f, 0.0f, 0.0f, 2.0f, 1.0f, color);
        RenderUtils.drawLine(entry, buffer, 1.0f, 2.0f, 0.0f, -1.0f, 2.0f, 0.0f, color);
        RenderUtils.drawLine(entry, buffer, 0.0f, 2.0f, 1.0f, 0.0f, 2.0f, -1.0f, color);
        RenderUtils.drawLine(entry, buffer, 0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f, color);
        RenderUtils.drawLine(entry, buffer, 0.0f, 0.0f, 0.0f, -1.0f, 2.0f, 0.0f, color);
        RenderUtils.drawLine(entry, buffer, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f, -1.0f, color);
        RenderUtils.drawLine(entry, buffer, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 1.0f, color);
        matrices.method_22909();
    }

    public static void drawItem(class_332 context, class_1799 stack, int x, int y, boolean large) {
        class_4587 matrixStack = context.method_51448();
        matrixStack.method_22903();
        matrixStack.method_46416((float)x, (float)y, 0.0f);
        if (large) {
            matrixStack.method_22905(1.5f, 1.5f, 1.5f);
        } else {
            matrixStack.method_22905(0.75f, 0.75f, 0.75f);
        }
        class_1799 renderStack = stack.method_7960() || stack.method_7909() == null ? new class_1799((class_1935)class_2246.field_10219) : stack;
        class_308.method_24211();
        context.method_51427(renderStack, 0, 0);
        class_308.method_24210();
        matrixStack.method_22909();
        if (stack.method_7960()) {
            matrixStack.method_22903();
            matrixStack.method_46416((float)x, (float)y, 250.0f);
            if (large) {
                matrixStack.method_22905(2.0f, 2.0f, 2.0f);
            }
            class_327 tr = WurstClient.MC.field_1772;
            context.method_51433(tr, "?", 3, 2, 0xF0F0F0, true);
            matrixStack.method_22909();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void fill2D(class_332 context, float x1, float y1, float x2, float y2, int color) {
        Matrix4f matrix = context.method_51448().method_23760().method_23761();
        context.method_64039(consumers -> {
            class_4588 buffer = consumers.getBuffer(class_1921.method_51784());
            buffer.method_22918(matrix, x1, y1, 0.0f).method_39415(color);
            buffer.method_22918(matrix, x1, y2, 0.0f).method_39415(color);
            buffer.method_22918(matrix, x2, y2, 0.0f).method_39415(color);
            buffer.method_22918(matrix, x2, y1, 0.0f).method_39415(color);
        });
    }

    public static void fillQuads2D(class_332 context, float[][] vertices, int color) {
        Matrix4f matrix = context.method_51448().method_23760().method_23761();
        context.method_64039(consumers -> {
            class_4588 buffer = consumers.getBuffer(class_1921.method_51784());
            for (float[] vertex : vertices) {
                buffer.method_22918(matrix, vertex[0], vertex[1], 0.0f).method_39415(color);
            }
        });
    }

    public static void fillTriangle2D(class_332 context, float[][] vertices, int color) {
        Matrix4f matrix = context.method_51448().method_23760().method_23761();
        context.method_64039(consumers -> {
            class_4588 buffer = consumers.getBuffer(class_1921.method_49047());
            for (float[] vertex : vertices) {
                buffer.method_22918(matrix, vertex[0], vertex[1], 0.0f).method_39415(color);
            }
        });
    }

    public static void drawLine2D(class_332 context, float x1, float y1, float x2, float y2, int color) {
        Matrix4f matrix = context.method_51448().method_23760().method_23761();
        context.method_64039(consumers -> {
            class_4588 buffer = consumers.getBuffer((class_1921)WurstRenderLayers.ONE_PIXEL_LINES);
            buffer.method_22918(matrix, x1, y1, 1.0f).method_39415(color);
            buffer.method_22918(matrix, x2, y2, 1.0f).method_39415(color);
        });
    }

    public static void drawBorder2D(class_332 context, float x1, float y1, float x2, float y2, int color) {
        Matrix4f matrix = context.method_51448().method_23760().method_23761();
        context.method_64039(consumers -> {
            class_4588 buffer = consumers.getBuffer((class_1921)WurstRenderLayers.ONE_PIXEL_LINE_STRIP);
            buffer.method_22918(matrix, x1, y1, 1.0f).method_39415(color);
            buffer.method_22918(matrix, x2, y1, 1.0f).method_39415(color);
            buffer.method_22918(matrix, x2, y2, 1.0f).method_39415(color);
            buffer.method_22918(matrix, x1, y2, 1.0f).method_39415(color);
            buffer.method_22918(matrix, x1, y1, 1.0f).method_39415(color);
        });
    }

    public static void drawLineStrip2D(class_332 context, float[][] vertices, int color) {
        Matrix4f matrix = context.method_51448().method_23760().method_23761();
        context.method_64039(consumers -> {
            class_4588 buffer = consumers.getBuffer((class_1921)WurstRenderLayers.ONE_PIXEL_LINE_STRIP);
            for (float[] vertex : vertices) {
                buffer.method_22918(matrix, vertex[0], vertex[1], 1.0f).method_39415(color);
            }
            buffer.method_22918(matrix, vertices[0][0], vertices[0][1], 1.0f).method_39415(color);
        });
    }

    public static void drawBoxShadow2D(class_332 context, int x1, int y1, int x2, int y2) {
        float[] acColor = WurstClient.INSTANCE.getGui().getAcColor();
        float xo1 = (float)x1 - 0.1f;
        float xo2 = (float)x2 + 0.1f;
        float yo1 = (float)y1 - 0.1f;
        float yo2 = (float)y2 + 0.1f;
        int outlineColor = RenderUtils.toIntColor(acColor, 0.5f);
        RenderUtils.drawBorder2D(context, xo1, yo1, xo2, yo2, outlineColor);
        float xs1 = x1 - 1;
        float xs2 = x2 + 1;
        float ys1 = y1 - 1;
        float ys2 = y2 + 1;
        int shadowColor1 = RenderUtils.toIntColor(acColor, 0.75f);
        int shadowColor2 = 0;
        class_4587 matrixStack = context.method_51448();
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        context.method_64039(consumers -> {
            class_4588 buffer = consumers.getBuffer(class_1921.method_51784());
            buffer.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_39415(shadowColor1);
            buffer.method_22918(matrix, (float)x2, (float)y1, 0.0f).method_39415(shadowColor1);
            buffer.method_22918(matrix, xs2, ys1, 0.0f).method_39415(shadowColor2);
            buffer.method_22918(matrix, xs1, ys1, 0.0f).method_39415(shadowColor2);
            buffer.method_22918(matrix, xs1, ys1, 0.0f).method_39415(shadowColor2);
            buffer.method_22918(matrix, xs1, ys2, 0.0f).method_39415(shadowColor2);
            buffer.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_39415(shadowColor1);
            buffer.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_39415(shadowColor1);
            buffer.method_22918(matrix, (float)x2, (float)y1, 0.0f).method_39415(shadowColor1);
            buffer.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_39415(shadowColor1);
            buffer.method_22918(matrix, xs2, ys2, 0.0f).method_39415(shadowColor2);
            buffer.method_22918(matrix, xs2, ys1, 0.0f).method_39415(shadowColor2);
            buffer.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_39415(shadowColor1);
            buffer.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_39415(shadowColor1);
            buffer.method_22918(matrix, xs1, ys2, 0.0f).method_39415(shadowColor2);
            buffer.method_22918(matrix, xs2, ys2, 0.0f).method_39415(shadowColor2);
        });
    }

    private static /* synthetic */ RenderUtils[] $values() {
        return new RenderUtils[0];
    }

    static {
        $VALUES = RenderUtils.$values();
    }

    public record ColoredPoint(class_243 point, int color) {
    }

    public record ColoredBox(class_238 box, int color) {
    }
}

