/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.wurstclient.Category;
import net.wurstclient.events.RenderListener;
import net.wurstclient.events.RightClickListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.FileSetting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.settings.SwingHandSetting;
import net.wurstclient.util.AutoBuildTemplate;
import net.wurstclient.util.BlockPlacer;
import net.wurstclient.util.BlockUtils;
import net.wurstclient.util.ChatUtils;
import net.wurstclient.util.DefaultAutoBuildTemplates;
import net.wurstclient.util.InteractionSimulator;
import net.wurstclient.util.RegionPos;
import net.wurstclient.util.RenderUtils;
import net.wurstclient.util.RotationUtils;
import net.wurstclient.util.json.JsonException;
import org.lwjgl.opengl.GL11;

public final class AutoBuildHack
extends Hack
implements UpdateListener,
RightClickListener,
RenderListener {
    private final FileSetting templateSetting = new FileSetting("Template", "Determines what to build.\n\nTemplates are just JSON files. Feel free to add your own or to edit / delete the default templates.\n\nIf you mess up, simply press the 'Reset to Defaults' button or delete the folder.", "autobuild", DefaultAutoBuildTemplates::createFiles);
    private final SliderSetting range = new SliderSetting("Range", "How far to reach when placing blocks.\nRecommended values:\n6.0 for vanilla\n4.25 for NoCheat+", 6.0, 1.0, 10.0, 0.05, SliderSetting.ValueDisplay.DECIMAL);
    private final CheckboxSetting checkLOS = new CheckboxSetting("Check line of sight", "Makes sure that you don't reach through walls when placing blocks. Can help with AntiCheat plugins but slows down building.", false);
    private final CheckboxSetting instaBuild = new CheckboxSetting("InstaBuild", "Builds small templates (<= 64 blocks) instantly.\nFor best results, stand close to the block you're placing.", true);
    private final CheckboxSetting fastPlace = new CheckboxSetting("Always FastPlace", "Builds as if FastPlace was enabled, even if it's not.", true);
    private Status status = Status.NO_TEMPLATE;
    private AutoBuildTemplate template;
    private LinkedHashSet<class_2338> remainingBlocks = new LinkedHashSet();

    public AutoBuildHack() {
        super("AutoBuild");
        this.setCategory(Category.BLOCKS);
        this.addSetting(this.templateSetting);
        this.addSetting(this.range);
        this.addSetting(this.checkLOS);
        this.addSetting(this.instaBuild);
        this.addSetting(this.fastPlace);
    }

    @Override
    public String getRenderName() {
        Object name = this.getName();
        switch (this.status.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                name = (String)name + " [Loading...]";
                break;
            }
            case 2: {
                name = (String)name + " [" + this.template.getName() + "]";
                break;
            }
            case 3: {
                double total = this.template.size();
                double placed = total - (double)this.remainingBlocks.size();
                double progress = (double)Math.round(placed / total * 10000.0) / 100.0;
                name = (String)name + " [" + this.template.getName() + "] " + progress + "%";
            }
        }
        return name;
    }

    @Override
    protected void onEnable() {
        AutoBuildHack.WURST.getHax().templateToolHack.setEnabled(false);
        EVENTS.add(UpdateListener.class, this);
        EVENTS.add(RightClickListener.class, this);
        EVENTS.add(RenderListener.class, this);
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
        EVENTS.remove(RightClickListener.class, this);
        EVENTS.remove(RenderListener.class, this);
        this.remainingBlocks.clear();
        this.status = this.template == null ? Status.NO_TEMPLATE : Status.IDLE;
    }

    @Override
    public void onRightClick(RightClickListener.RightClickEvent event) {
        if (this.status != Status.IDLE) {
            return;
        }
        class_239 hitResult = AutoBuildHack.MC.field_1765;
        if (hitResult == null || hitResult.method_17783() != class_239.class_240.field_1332 || !(hitResult instanceof class_3965)) {
            return;
        }
        class_3965 blockHitResult = (class_3965)hitResult;
        class_2338 hitResultPos = blockHitResult.method_17777();
        if (!BlockUtils.canBeClicked(hitResultPos)) {
            return;
        }
        class_2338 startPos = hitResultPos.method_10093(blockHitResult.method_17780());
        class_2350 direction = AutoBuildHack.MC.field_1724.method_5735();
        this.remainingBlocks = this.template.getPositions(startPos, direction);
        if (this.instaBuild.isChecked() && this.template.size() <= 64) {
            this.buildInstantly();
        } else {
            this.status = Status.BUILDING;
        }
    }

    @Override
    public void onUpdate() {
        switch (this.status.ordinal()) {
            case 0: {
                this.loadSelectedTemplate();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (this.template.isSelected(this.templateSetting)) break;
                this.loadSelectedTemplate();
                break;
            }
            case 3: {
                this.buildNormally();
            }
        }
    }

    @Override
    public void onRender(class_4587 matrixStack, float partialTicks) {
        if (this.status != Status.BUILDING) {
            return;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2884);
        matrixStack.method_22903();
        RegionPos region = RenderUtils.getCameraRegion();
        RenderUtils.applyRegionalRenderOffset(matrixStack, region);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
        RenderSystem.setShader((class_10156)class_10142.field_53875);
        double boxStart = 0.0625;
        double boxEnd = 0.9375;
        class_238 box = new class_238(boxStart, boxStart, boxStart, boxEnd, boxEnd, boxEnd).method_996(region.negate().toBlockPos());
        ArrayList blocksToDraw = this.remainingBlocks.stream().filter(pos -> BlockUtils.getState(pos).method_45474()).limit(1024L).collect(Collectors.toCollection(ArrayList::new));
        GL11.glDepthMask((boolean)false);
        RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)0.0f, (float)0.15f);
        class_243 eyesPos = RotationUtils.getEyesPos();
        double rangeSq = this.range.getValueSq();
        blocksToDraw.stream().filter(pos -> pos.method_19770((class_2374)eyesPos) <= rangeSq).map(pos -> box.method_996(pos)).forEach(offsetBox -> RenderUtils.drawSolidBox(offsetBox, matrixStack));
        GL11.glDepthMask((boolean)true);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
        blocksToDraw.stream().map(pos -> box.method_996(pos)).forEach(offsetBox -> RenderUtils.drawOutlinedBox(offsetBox, matrixStack));
        matrixStack.method_22909();
        GL11.glDisable((int)3042);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void buildNormally() {
        this.remainingBlocks.removeIf(pos -> !BlockUtils.getState(pos).method_45474());
        if (this.remainingBlocks.isEmpty()) {
            this.status = Status.IDLE;
            return;
        }
        if (!this.fastPlace.isChecked() && AutoBuildHack.MC.field_1752 > 0) {
            return;
        }
        double rangeSq = this.range.getValueSq();
        for (class_2338 pos2 : this.remainingBlocks) {
            BlockPlacer.BlockPlacingParams params = BlockPlacer.getBlockPlacingParams(pos2);
            if (params == null || params.distanceSq() > rangeSq || this.checkLOS.isChecked() && !params.lineOfSight()) continue;
            AutoBuildHack.MC.field_1752 = 4;
            RotationUtils.getNeededRotations(params.hitVec()).sendPlayerLookPacket();
            InteractionSimulator.rightClickBlock(params.toHitResult());
            break;
        }
    }

    private void buildInstantly() {
        double rangeSq = this.range.getValueSq();
        for (class_2338 pos : this.remainingBlocks) {
            BlockPlacer.BlockPlacingParams params;
            if (!BlockUtils.getState(pos).method_45474() || (params = BlockPlacer.getBlockPlacingParams(pos)) == null || params.distanceSq() > rangeSq) continue;
            InteractionSimulator.rightClickBlock(params.toHitResult(), SwingHandSetting.SwingHand.OFF);
        }
        this.remainingBlocks.clear();
    }

    private void loadSelectedTemplate() {
        this.status = Status.LOADING;
        Path path = this.templateSetting.getSelectedFile();
        try {
            this.template = AutoBuildTemplate.load(path);
            this.status = Status.IDLE;
        }
        catch (IOException | JsonException e) {
            Path fileName = path.getFileName();
            ChatUtils.error("Couldn't load template '" + String.valueOf(fileName) + "'.");
            String simpleClassName = e.getClass().getSimpleName();
            String message = e.getMessage();
            ChatUtils.message(simpleClassName + ": " + message);
            e.printStackTrace();
            this.setEnabled(false);
        }
    }

    public Path getFolder() {
        return this.templateSetting.getFolder();
    }

    private static enum Status {
        NO_TEMPLATE,
        LOADING,
        IDLE,
        BUILDING;

    }
}

