/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks.autofish;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.stream.Stream;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1297;
import net.minecraft.class_1536;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2767;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4587;
import net.minecraft.class_9801;
import net.wurstclient.WurstClient;
import net.wurstclient.hacks.autofish.FishingSpot;
import net.wurstclient.hacks.autofish.FishingSpotManager;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.ColorSetting;
import net.wurstclient.settings.Setting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.util.EntityUtils;
import net.wurstclient.util.RegionPos;
import net.wurstclient.util.RenderUtils;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public final class AutoFishDebugDraw {
    private final CheckboxSetting debugDraw = new CheckboxSetting("Debug draw", "Shows where bites are occurring and where they will be detected. Useful for optimizing your 'Valid range' setting.", false);
    private final ColorSetting ddColor = new ColorSetting("DD color", "Color of the debug draw, if enabled.", Color.RED);
    private final SliderSetting validRange;
    private final FishingSpotManager fishingSpots;
    private class_243 lastSoundPos;

    public AutoFishDebugDraw(SliderSetting validRange, FishingSpotManager fishingSpots) {
        this.validRange = validRange;
        this.fishingSpots = fishingSpots;
    }

    public Stream<Setting> getSettings() {
        return Stream.of(this.debugDraw, this.ddColor);
    }

    public void reset() {
        this.lastSoundPos = null;
    }

    public void updateSoundPos(class_2767 sound) {
        this.lastSoundPos = new class_243(sound.method_11890(), sound.method_11889(), sound.method_11893());
    }

    public void render(class_4587 matrixStack, float partialTicks) {
        if (!this.debugDraw.isChecked() && !this.fishingSpots.isMcmmoMode()) {
            return;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2929);
        matrixStack.method_22903();
        RegionPos region = RenderUtils.getCameraRegion();
        RenderUtils.applyRegionalRenderOffset(matrixStack, region);
        if (this.debugDraw.isChecked()) {
            class_1536 bobber = WurstClient.MC.field_1724.field_7513;
            if (bobber != null) {
                this.drawValidRange(matrixStack, partialTicks, bobber, region);
            }
            if (this.lastSoundPos != null) {
                this.drawLastBite(matrixStack, region);
            }
            this.drawFishingSpots(matrixStack, region);
        }
        if (this.fishingSpots.isMcmmoMode()) {
            this.drawMcmmoRange(matrixStack, region);
        }
        matrixStack.method_22909();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2929);
        GL11.glDisable((int)3042);
    }

    private void drawValidRange(class_4587 matrixStack, float partialTicks, class_1536 bobber, RegionPos region) {
        matrixStack.method_22903();
        class_243 pos = EntityUtils.getLerpedPos((class_1297)bobber, partialTicks).method_1020(region.toVec3d());
        matrixStack.method_22904(pos.method_10216(), pos.method_10214(), pos.method_10215());
        this.ddColor.setAsShaderColor(0.5f);
        double vr = this.validRange.getValue();
        class_238 vrBox = new class_238(-vr, -0.0625, -vr, vr, 0.0625, vr);
        RenderUtils.drawOutlinedBox(vrBox, matrixStack);
        matrixStack.method_22909();
    }

    private void drawLastBite(class_4587 matrixStack, RegionPos region) {
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        RenderSystem.setShader((class_10156)class_10142.field_53875);
        matrixStack.method_22903();
        matrixStack.method_22904(this.lastSoundPos.field_1352 - (double)region.x(), this.lastSoundPos.field_1351, this.lastSoundPos.field_1350 - (double)region.z());
        this.ddColor.setAsShaderColor(0.5f);
        class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_29344, class_290.field_1592);
        bufferBuilder.method_22918(matrix, -0.125f, 0.0f, -0.125f);
        bufferBuilder.method_22918(matrix, 0.125f, 0.0f, 0.125f);
        bufferBuilder.method_22918(matrix, 0.125f, 0.0f, -0.125f);
        bufferBuilder.method_22918(matrix, -0.125f, 0.0f, 0.125f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        matrixStack.method_22909();
    }

    private void drawFishingSpots(class_4587 matrixStack, RegionPos region) {
        class_238 headBox = new class_238(-0.25, 0.0, -0.25, 0.25, 0.5, 0.25);
        class_238 noseBox = headBox.method_989(0.125, 0.125, 0.5).method_1002(0.25, 0.35, 0.45);
        this.ddColor.setAsShaderColor(0.75f);
        for (FishingSpot spot : this.fishingSpots.getFishingSpots()) {
            class_243 playerPos = spot.input().pos().method_1020(region.toVec3d());
            class_243 bobberPos = spot.bobberPos().method_1020(region.toVec3d());
            matrixStack.method_22903();
            matrixStack.method_22904(playerPos.field_1352, playerPos.field_1351, playerPos.field_1350);
            matrixStack.method_22903();
            matrixStack.method_22907(spot.input().rotation().toQuaternion());
            RenderUtils.drawOutlinedBox(headBox, matrixStack);
            RenderUtils.drawOutlinedBox(noseBox, matrixStack);
            if (!spot.openWater()) {
                RenderUtils.drawCrossBox(headBox, matrixStack);
            }
            matrixStack.method_22909();
            RenderUtils.drawArrow(class_243.field_1353, bobberPos.method_1020(playerPos), matrixStack);
            matrixStack.method_22909();
        }
    }

    private void drawMcmmoRange(class_4587 matrixStack, RegionPos region) {
        FishingSpot lastSpot = this.fishingSpots.getLastSpot();
        if (lastSpot == null) {
            return;
        }
        if (this.fishingSpots.isSetupDone() && !this.debugDraw.isChecked()) {
            return;
        }
        class_243 bobberPos = lastSpot.bobberPos().method_1020(region.toVec3d());
        matrixStack.method_22903();
        matrixStack.method_22904(bobberPos.field_1352, bobberPos.field_1351, bobberPos.field_1350);
        int mcmmoRange = this.fishingSpots.getRange();
        class_238 rangeBox = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).method_1009((double)mcmmoRange, 1.0, (double)mcmmoRange);
        RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)0.25f);
        RenderUtils.drawSolidBox(rangeBox, matrixStack);
        RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)0.5f);
        RenderUtils.drawOutlinedBox(rangeBox, matrixStack);
        RenderUtils.drawOutlinedBox(rangeBox.method_35580(0.0, 1.0, 0.0), matrixStack);
        matrixStack.method_22909();
    }
}

