/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks.chestesp;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_8555;
import net.minecraft.class_9801;
import net.wurstclient.hacks.chestesp.ChestEspGroup;
import net.wurstclient.util.RegionPos;
import net.wurstclient.util.RenderUtils;
import net.wurstclient.util.RotationUtils;
import org.joml.Matrix4f;

public final class ChestEspRenderer {
    private static class_291 solidBox;
    private static class_291 outlinedBox;
    private final class_4587 matrixStack;
    private final RegionPos region;
    private final class_243 start;

    public ChestEspRenderer(class_4587 matrixStack, float partialTicks) {
        this.matrixStack = matrixStack;
        this.region = RenderUtils.getCameraRegion();
        this.start = RotationUtils.getClientLookVec(partialTicks).method_1019(RenderUtils.getCameraPos()).method_1020(this.region.toVec3d());
    }

    public void renderBoxes(ChestEspGroup group) {
        float[] colorF = group.getColorF();
        for (class_238 box : group.getBoxes()) {
            this.matrixStack.method_22903();
            this.matrixStack.method_22904(box.field_1323 - (double)this.region.x(), box.field_1322, box.field_1321 - (double)this.region.z());
            this.matrixStack.method_22905((float)(box.field_1320 - box.field_1323), (float)(box.field_1325 - box.field_1322), (float)(box.field_1324 - box.field_1321));
            Matrix4f viewMatrix = this.matrixStack.method_23760().method_23761();
            Matrix4f projMatrix = RenderSystem.getProjectionMatrix();
            class_5944 shader = RenderSystem.getShader();
            RenderUtils.setShaderColor(colorF, 0.25f);
            solidBox.method_1353();
            solidBox.method_34427(viewMatrix, projMatrix, shader);
            class_291.method_1354();
            RenderUtils.setShaderColor(colorF, 0.5f);
            outlinedBox.method_1353();
            outlinedBox.method_34427(viewMatrix, projMatrix, shader);
            class_291.method_1354();
            this.matrixStack.method_22909();
        }
    }

    public void renderLines(ChestEspGroup group) {
        if (group.getBoxes().isEmpty()) {
            return;
        }
        Matrix4f matrix = this.matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        float[] colorF = group.getColorF();
        RenderUtils.setShaderColor(colorF, 0.5f);
        class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_29344, class_290.field_1592);
        for (class_238 box : group.getBoxes()) {
            class_243 end = box.method_1005().method_1020(this.region.toVec3d());
            bufferBuilder.method_22918(matrix, (float)this.start.field_1352, (float)this.start.field_1351, (float)this.start.field_1350);
            bufferBuilder.method_22918(matrix, (float)end.field_1352, (float)end.field_1351, (float)end.field_1350);
        }
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
    }

    public static void prepareBuffers() {
        ChestEspRenderer.closeBuffers();
        solidBox = new class_291(class_8555.field_54340);
        outlinedBox = new class_291(class_8555.field_54340);
        class_238 box = new class_238(class_2338.field_10980);
        RenderUtils.drawSolidBox(box, solidBox);
        RenderUtils.drawOutlinedBox(box, outlinedBox);
    }

    public static void closeBuffers() {
        Stream.of(solidBox, outlinedBox).filter(Objects::nonNull).forEach(class_291::close);
    }
}

