/*----------------------------------------------------------------------------------------------------------

	  .-,.-.,-. )\.---.  .')      .')     )\    /(
	  ).-, ,-.((   ,-._(( /      ( /      \ (_.' /
	      ))    \  '-,   ))       ))       )  _.'
	 .-._((      ) ,-`   )'._.-.  )'._.-.  / /
	(      )    (  ``-. (       )(       )(  \
	 '._.\(      )..-.(  )/,__.'  )/,__.'  ).'

							     .'(   .-./(   /`-.  .')        )\.-.
							 ,') \  ),'     ),' _  \( /       ,'     )
							(  /(/ /(  .-, ((  '-' ( ))      (  .-, (
							 )    (  ) '._\ )) ,_ .' )'._.-.  ) '._\ )
							(  .'\ \(  ,   ((  ' ) \(       )(  ,   (
							 )/   )/ )/ ._.' )/   )/ )/,__.'  )/ ._.'

												Ver. 5.1

A Minecraft shaderpack that makes the whole world shake and wobble like jelly. Beware of any possible motion
sickness!

This shaderpack requires OptiFine; download and run OptiFine at least once, then put this shaderpack into
the shaderpacks folder.
You can find OptiFine here: http://optifine.net/home

Created by Beed28
Official forum topic: http://www.minecraftforum.net/forums/mapping-and-modding/minecraft-mods/1290502/
----------------------------------------------------------------------------------------------------------*/

#version 120

//#define ENABLE_CUSTOMISATION
#define CUSTOM_ROLL_SPEED 4.0
#define CUSTOM_ROLL_VALUE_1 4.0
#define CUSTOM_ROLL_VALUE_2 6.0
#define CUSTOM_BOUNCE_SPEED 3.5
#define CUSTOM_BOUNCE_VALUE_1 4.0
#define CUSTOM_BOUNCE_VALUE_2 8.0

#define WOBBLE_AMPLIFIER 0.0

//#define FAST_JELLY

varying vec4 texcoord;
varying vec4 color;
varying vec4 lmcoord;

attribute vec4 mc_Entity;

uniform float frameTimeCounter;
uniform vec3 cameraPosition;
uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;

void main() {

	vec4 position = gl_ModelViewMatrix * gl_Vertex;

	position = gbufferModelViewInverse * position;
	vec3 worldpos = position.xyz + cameraPosition;

	float PI = 3.14159265358979323846264;

	//Ugly attempt at a workaround for frameTimeCounter overflowing on certain systems.
	float jellyTime = frameTimeCounter;
	if (frameTimeCounter >= 400.0)
		{jellyTime = frameTimeCounter - 400.0;}
	if (frameTimeCounter >= 800.0)
		{jellyTime = frameTimeCounter - 800.0;}
	if (frameTimeCounter >= 1200.0)
		{jellyTime = frameTimeCounter - 1200.0;}
	if (frameTimeCounter >= 1600.0)
		{jellyTime = frameTimeCounter - 1600.0;}
	if (frameTimeCounter >= 2000.0)
		{jellyTime = frameTimeCounter - 2000.0;}
	if (frameTimeCounter >= 2400.0)
		{jellyTime = frameTimeCounter - 2400.0;}
	if (frameTimeCounter >= 2800.0)
		{jellyTime = frameTimeCounter - 2800.0;}
	if (frameTimeCounter >= 3200.0)
		{jellyTime = frameTimeCounter - 3200.0;}

	if (gl_Color.a != 0.4) {

				float varyingBounceSpeed =	(3.0 * sin(frameTimeCounter / 23.0)) + 9.0;
				float varyingBounce1 =		(4.0 * sin(frameTimeCounter / 34.0)) + 7.0;
				float varyingBounce2 =		(4.0 * sin(frameTimeCounter / 56.0)) + 7.0;
				float varyingRollSpeed =	(3.0 * sin(frameTimeCounter / 28.0)) + 9.0;
				float varyingRoll1 =		(2.5 * sin(frameTimeCounter / 32.0)) + 4.0;
				float varyingRoll2 =		(2.5 * sin(frameTimeCounter / 55.0)) + 4.0;

				float jellyBounce = ((varyingBounce1 - varyingBounce2) * sin(frameTimeCounter / varyingBounceSpeed)) + (varyingBounce1 + varyingBounce2);
				float jellyRoll = ((varyingRoll1 - varyingRoll2) * sin(frameTimeCounter / varyingRollSpeed)) + (varyingRoll1 + varyingRoll2);
				float distanceSquared = position.x * position.x + position.z * position.z + position.y * position.y;

				#ifdef ENABLE_CUSTOMISATION
				jellyBounce = ((CUSTOM_BOUNCE_VALUE_1 - CUSTOM_BOUNCE_VALUE_2) * sin(frameTimeCounter / CUSTOM_BOUNCE_SPEED)) + (CUSTOM_BOUNCE_VALUE_1 + CUSTOM_BOUNCE_VALUE_2);
				jellyRoll = ((CUSTOM_ROLL_VALUE_1 - CUSTOM_ROLL_VALUE_2) * sin(frameTimeCounter / CUSTOM_ROLL_SPEED)) + (CUSTOM_ROLL_VALUE_1 + CUSTOM_ROLL_VALUE_2);
				#endif

				position.y += sin(sin(jellyTime / 0.5) * atan(distanceSquared / 800.0)) / 3.0 * jellyBounce / 20.0;

				float amplifyIntensity = clamp(WOBBLE_AMPLIFIER * 0.8, 1.0, 100.0);
				float amplifyFrequency = clamp(WOBBLE_AMPLIFIER * 0.32, 1.0, 100.0);

				if (gl_Color.a != 0.0) {
					float y = position.y;
					float x = position.x;
					float z = position.z;
					float om = sin(jellyTime / (0.053 * amplifyFrequency)) / 1280.0 * jellyBounce * amplifyIntensity;
					float on = sin(jellyTime / (0.058 * amplifyFrequency)) / 1280.0 * jellyBounce * amplifyIntensity;
					position.y = x * sin(om) + z * sin(on) + y * cos(om);
					position.x = x * cos(om) - y * sin(om);
					position.z = z * cos(om) - y * sin(on);
					}
				if (gl_Color.a != 0.0) {
					float y = position.y;
					float x = position.x;
					float z = position.z;
					float om = sin(jellyTime / (0.174 * amplifyFrequency)) / 640.0 * jellyRoll * amplifyIntensity;
					float on = sin(jellyTime / (0.179 * amplifyFrequency)) / 640.0 * jellyRoll * amplifyIntensity;
					position.y = x * sin(om) + z * sin(on) + y * cos(om);
					position.x = x * cos(om) - y * sin(om);
					position.z = z * cos(om) - y * sin(on);
					}
				#ifndef FAST_JELLY
				if (gl_Color.a != 0.0) {
					float y = position.y;
					float x = position.x;
					float z = position.z;
					float om = sin(jellyTime / 0.06) / 1408.0 * jellyBounce;
					float on = sin(jellyTime / 0.06 + 0.8) / 1408.0 * jellyBounce;
					position.x = x * cos(om) - y * sin(om);
					position.z = z * cos(on) - y * sin(on);
					}
				#endif

				position.y += sin(jellyTime / 0.0425) * jellyBounce / 80.0;
				position.z += 1.2 * sin(jellyTime / 0.07) * jellyRoll / 192.0;
				position.x += 1.2 * sin(jellyTime / 0.08) * jellyRoll / 192.0;
		}

	position = gbufferModelView * position;

	gl_Position = gl_ProjectionMatrix * position;

	color = gl_Color;

	texcoord = gl_TextureMatrix[0] * gl_MultiTexCoord0;

	lmcoord = gl_TextureMatrix[1] * gl_MultiTexCoord1;

	gl_FogFragCoord = gl_Position.z;
}