/*----------------------------------------------------------------------------------------------------------

	  .-,.-.,-. )\.---.  .')      .')     )\    /(
	  ).-, ,-.((   ,-._(( /      ( /      \ (_.' /
	      ))    \  '-,   ))       ))       )  _.'
	 .-._((      ) ,-`   )'._.-.  )'._.-.  / /
	(      )    (  ``-. (       )(       )(  \
	 '._.\(      )..-.(  )/,__.'  )/,__.'  ).'

							     .'(   .-./(   /`-.  .')        )\.-.
							 ,') \  ),'     ),' _  \( /       ,'     )
							(  /(/ /(  .-, ((  '-' ( ))      (  .-, (
							 )    (  ) '._\ )) ,_ .' )'._.-.  ) '._\ )
							(  .'\ \(  ,   ((  ' ) \(       )(  ,   (
							 )/   )/ )/ ._.' )/   )/ )/,__.'  )/ ._.'

												Ver. 5.1

A Minecraft shaderpack that makes the whole world shake and wobble like jelly. Beware of any possible motion
sickness!

This shaderpack requires OptiFine; download and run OptiFine at least once, then put this shaderpack into
the shaderpacks folder.
You can find OptiFine here: http://optifine.net/home

Created by Beed28
Official forum topic: http://www.minecraftforum.net/forums/mapping-and-modding/minecraft-mods/1290502/
----------------------------------------------------------------------------------------------------------*/

#version 120

#define WAVING_GRASS
#define WAVING_SAPLINGS
#define WAVING_DEAD_BUSH
#define WAVING_FLOWERS
#define WAVING_WHEAT
#define WAVING_WART
#define WAVING_LEAVES
#define WAVING_VINES
#define WAVING_SUGAR_CANE
#define WAVING_LARGE_FLOWERS
#define WAVING_COBWEBS
#define WAVING_SLIME_BLOCKS

//#define ENABLE_CUSTOMISATION
#define CUSTOM_ROLL_SPEED 4.0
#define CUSTOM_ROLL_VALUE_1 4.0
#define CUSTOM_ROLL_VALUE_2 6.0
#define CUSTOM_BOUNCE_SPEED 3.5
#define CUSTOM_BOUNCE_VALUE_1 4.0
#define CUSTOM_BOUNCE_VALUE_2 8.0

//#define LITERAL_JELLY_MODE
#define LITERAL_JELLY_SPEED 0.06
#define LITERAL_JELLY_WAVELENGTH 1.0

#define WOBBLE_AMPLIFIER 0.0

//#define FAST_JELLY

varying vec4 texcoord;
varying vec4 color;
varying vec4 lmcoord;

attribute vec4 mc_Entity;
attribute vec4 mc_midTexCoord;

uniform float frameTimeCounter;
uniform vec3 cameraPosition;
uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;

void main() {

	vec4 position = gl_ModelViewMatrix * gl_Vertex;

	position = gbufferModelViewInverse * position;
	vec3 worldpos = position.xyz + cameraPosition;

	bool istopv = gl_MultiTexCoord0.t < mc_midTexCoord.t;
	float PI = 3.14159265358979323846264;

	//Ugly attempt at a workaround for frameTimeCounter overflowing on certain systems.
	float jellyTime = frameTimeCounter;
	if (frameTimeCounter >= 400.0)
		{jellyTime = frameTimeCounter - 400.0;}
	if (frameTimeCounter >= 800.0)
		{jellyTime = frameTimeCounter - 800.0;}
	if (frameTimeCounter >= 1200.0)
		{jellyTime = frameTimeCounter - 1200.0;}
	if (frameTimeCounter >= 1600.0)
		{jellyTime = frameTimeCounter - 1600.0;}
	if (frameTimeCounter >= 2000.0)
		{jellyTime = frameTimeCounter - 2000.0;}
	if (frameTimeCounter >= 2400.0)
		{jellyTime = frameTimeCounter - 2400.0;}
	if (frameTimeCounter >= 2800.0)
		{jellyTime = frameTimeCounter - 2800.0;}
	if (frameTimeCounter >= 3200.0)
		{jellyTime = frameTimeCounter - 3200.0;}

	if (gl_Color.a != 0.8) {

				float varyingBounceSpeed =	(3.0 * sin(frameTimeCounter / 23.0)) + 9.0;
				float varyingBounce1 =		(4.0 * sin(frameTimeCounter / 34.0)) + 7.0;
				float varyingBounce2 =		(4.0 * sin(frameTimeCounter / 56.0)) + 7.0;
				float varyingRollSpeed =	(3.0 * sin(frameTimeCounter / 28.0)) + 9.0;
				float varyingRoll1 =		(2.5 * sin(frameTimeCounter / 32.0)) + 4.0;
				float varyingRoll2 =		(2.5 * sin(frameTimeCounter / 55.0)) + 4.0;

				float jellyBounce = ((varyingBounce1 - varyingBounce2) * sin(frameTimeCounter / varyingBounceSpeed)) + (varyingBounce1 + varyingBounce2);
				float jellyRoll = ((varyingRoll1 - varyingRoll2) * sin(frameTimeCounter / varyingRollSpeed)) + (varyingRoll1 + varyingRoll2);
				float distanceSquared = position.x * position.x + position.z * position.z + position.y * position.y;

				#ifdef ENABLE_CUSTOMISATION
				jellyBounce = ((CUSTOM_BOUNCE_VALUE_1 - CUSTOM_BOUNCE_VALUE_2) * sin(frameTimeCounter / CUSTOM_BOUNCE_SPEED)) + (CUSTOM_BOUNCE_VALUE_1 + CUSTOM_BOUNCE_VALUE_2);
				jellyRoll = ((CUSTOM_ROLL_VALUE_1 - CUSTOM_ROLL_VALUE_2) * sin(frameTimeCounter / CUSTOM_ROLL_SPEED)) + (CUSTOM_ROLL_VALUE_1 + CUSTOM_ROLL_VALUE_2);
				#endif

				position.y += 0.16 * jellyBounce / 16.0;

				position.y += 4.5 * sin(sin(jellyTime / 0.5) * atan(distanceSquared / 800.0)) / 3.0 * jellyBounce / 20.0;

				float amplifyIntensity = clamp(WOBBLE_AMPLIFIER * 0.8, 1.0, 100.0);
				float amplifyWavelength = clamp(WOBBLE_AMPLIFIER * 0.25, 1.0, 100.0);
				float amplifyFrequency = clamp(WOBBLE_AMPLIFIER * 0.32, 1.0, 100.0);

				if (gl_Color.a != 0.0) {
					float y = position.y;
					float x = position.x;
					float z = position.z;
					float om = sin(sin(jellyTime / (0.053 * amplifyFrequency) - sqrt((position.z * position.z + position.x * position.x) / (896.0 / amplifyWavelength)))) / 1280.0 * jellyBounce * amplifyIntensity;
					float on = sin(sin(jellyTime / (0.058 * amplifyFrequency) - sqrt((position.z * position.z + position.x * position.x) / (896.0 / amplifyWavelength)))) / 1280.0 * jellyBounce * amplifyIntensity;
					position.y = x * sin(om) + z * sin(on) + y * cos(om);
					position.x = x * cos(om) - y * sin(om);
					position.z = z * cos(om) - y * sin(on);
					}
				if (gl_Color.a != 0.0) {
					float y = position.y;
					float x = position.x;
					float z = position.z;
					float om = sin(sin(jellyTime / (0.174 * amplifyFrequency) - sqrt((position.z * position.z + position.x * position.x) / (1152.0 / amplifyWavelength)))) / 640.0 * jellyRoll * amplifyIntensity;
					float on = sin(sin(jellyTime / (0.179 * amplifyFrequency) - sqrt((position.z * position.z + position.x * position.x) / (1152.0 / amplifyWavelength)))) / 640.0 * jellyRoll * amplifyIntensity;
					position.y = x * sin(om) + z * sin(on) + y * cos(om);
					position.x = x * cos(om) - y * sin(om);
					position.z = z * cos(om) - y * sin(on);
					}
				#ifndef FAST_JELLY
				if (gl_Color.a != 0.0) {
					float y = position.y;
					float x = position.x;
					float z = position.z;
					float om = sin(sin(jellyTime / 0.06  - sqrt((worldpos.y) * 2.5))) / 1408.0 * jellyBounce;
					float on = sin(sin(jellyTime / 0.06 + 0.8 - sqrt((worldpos.y) * 2.5))) / 1408.0 * jellyBounce;
					position.x = x * cos(om) - y * sin(om);
					position.z = z * cos(on) - y * sin(on);
					}
				#endif

				#ifndef FAST_JELLY
				if ((mc_Entity.x == 31.0 && istopv) || //Grass
					(mc_Entity.x == 32.0 && istopv) || //Dead bush
					(mc_Entity.x == 51.0 && istopv) || //Fire
					(mc_Entity.x == 59.0 && istopv) || //Wheat
					(mc_Entity.x == 115.0 && istopv) || //Nether Wart
					(mc_Entity.x == 141.0 && istopv) || //Carrots
					(mc_Entity.x == 142.0 && istopv) || //Potatoes
					(mc_Entity.x == 06.0 && istopv)) //Saplings
					{position.y += sin(jellyTime / 0.0425 - 0.8) * jellyBounce / 80.0;}
				else if ((mc_Entity.x == 37.0 && istopv) || (mc_Entity.x == 38.0 && istopv)) //Dandelion, Rose
					{position.y += sin(jellyTime / 0.0425 - 1.2) * jellyBounce / 80.0;}
				else if (mc_Entity.x == 39.0 && istopv) //Brown Mushroom
					{position.y += sin(jellyTime / 0.0425 - 1.5) * jellyBounce / 80.0;}
				else if (mc_Entity.x == 40.0 && istopv) //Red Mushroom
					{position.y += sin(jellyTime / 0.0425 - 2.5) * jellyBounce / 80.0;}
				else if (mc_Entity.x == 106.0) //Vines
					{position.y += sin(jellyTime / 0.0425 - 0.21) * jellyBounce / 80.0;}
				else if (mc_Entity.x == 18.0 || mc_Entity.x == 161.0) //Leaves
					{position.y += sin(jellyTime / 0.0425 - 0.37) * jellyBounce / 80.0;
					position.y -= 0.055 * (jellyBounce / 24.0);}
				else if (mc_Entity.x == 78.0) //Snow
					{
					#ifndef LITERAL_JELLY_MODE
					position.y += sin(jellyTime / 0.0425 - (0.19 / clamp(WOBBLE_AMPLIFIER / 6.0, 1.0, 100.0))) * jellyBounce / 80.0;
					position.y -= (0.048 * (jellyBounce / 24.0)) / clamp(WOBBLE_AMPLIFIER / 6.0, 1.0, 100.0);
					#else
					position.y += sin(jellyTime / 0.0425) * jellyBounce / 80.0;
					#endif
					}
				else if (mc_Entity.x == 83.0 || mc_Entity.x == 175.0) //Sugar Cane, Large Flowers
					{position.y += sin(jellyTime / 0.0425 - 0.5) * jellyBounce / 80.0;
					position.y -= 0.1;}
				else if (mc_Entity.x == 117.0) //Brewing Stand
					{position.y += sin(jellyTime / 0.0425 - 0.3) * jellyBounce / 80.0;}
				else
					{position.y += sin(jellyTime / 0.0425) * jellyBounce / 80.0;}
				#else
				position.y += sin(jellyTime / 0.0425) * jellyBounce / 80.0;
				#endif

				position.z += 1.2 * sin(jellyTime / 0.07) * jellyRoll / 192.0;
				position.x += 1.2 * sin(jellyTime / 0.08) * jellyRoll / 192.0;

				//Water would splash about like crazy when your whole world is shaking like jelly. :)
				if (mc_Entity.x == 09.0 || mc_Entity.x == 111.0) {
					position.y += 0.14 * sin(6.0 * PI * (jellyTime / 0.89 + worldpos.x / 25.0  + worldpos.z / 24.0)) * (jellyBounce / 34.0);
					position.y += 0.14 * sin(6.0 * PI * (jellyTime / 1.09 + worldpos.x / 27.0  + -worldpos.z / 26.0)) * (jellyBounce / 34.0);
					position.y += 0.14 * sin(6.0 * PI * (jellyTime / 1.29 + -worldpos.x / 29.0  + worldpos.z / 28.0)) * (jellyBounce / 34.0);

					position.y += 0.14 * sin(6.0 * PI * (jellyTime / 3.09 + worldpos.x / 45.0  + worldpos.z / 44.0)) * (jellyRoll / 34.0);
					position.y += 0.14 * sin(6.0 * PI * (jellyTime / 3.29 + worldpos.x / 47.0  + -worldpos.z / 46.0)) * (jellyRoll / 34.0);
					position.y += 0.14 * sin(6.0 * PI * (jellyTime / 3.49 + -worldpos.x / 49.0  + worldpos.z / 48.0)) * (jellyRoll / 34.0);
					position.y -= 0.1 * (jellyBounce + jellyRoll) / 14.0;}
				//And lava too, to a smaller extent
				#ifndef FAST_JELLY
				if (mc_Entity.x == 11.0) {
					position.y += 0.05 * sin(6.0 * PI * (jellyTime / 1.21 + worldpos.x / 25.0  + worldpos.z / 24.0)) * (jellyBounce / 34.0);
					position.y += 0.05 * sin(6.0 * PI * (jellyTime / 1.41 + worldpos.x / 27.0  + -worldpos.z / 26.0)) * (jellyBounce / 34.0);
					position.y += 0.05 * sin(6.0 * PI * (jellyTime / 1.61 + -worldpos.x / 29.0  + worldpos.z / 28.0)) * (jellyBounce / 34.0);
					
					position.y += 0.05 * sin(6.0 * PI * (jellyTime / 3.49 + worldpos.x / 45.0  + worldpos.z / 44.0)) * (jellyRoll / 34.0);
					position.y += 0.05 * sin(6.0 * PI * (jellyTime / 3.69 + worldpos.x / 47.0  + -worldpos.z / 46.0)) * (jellyRoll / 34.0);
					position.y += 0.05 * sin(6.0 * PI * (jellyTime / 3.89 + -worldpos.x / 49.0  + worldpos.z / 48.0)) * (jellyRoll / 34.0);
					position.y -= 0.1 * (jellyBounce + jellyRoll) / 96.0;}
				#endif


#ifdef LITERAL_JELLY_MODE
	if (gl_Color.a != 0.0) {
		float speed = LITERAL_JELLY_SPEED;
		float magnitude = (sin(((worldpos.y + worldpos.x + worldpos.z) / LITERAL_JELLY_WAVELENGTH + jellyTime * PI / (0.5)))) * 0.08;
		float d0 = sin(jellyTime * PI / (64.2 * speed)) * 2.0 - 1.5;
		float d1 = sin(jellyTime * PI / (64.1 * speed)) * 2.0 - 1.5;
		float d2 = sin(jellyTime * PI / (64.0 * speed)) * 2.0 - 1.5;
		float d3 = sin(jellyTime * PI / (64.3 * speed)) * 2.0 - 1.5;
		position.x += sin((jellyTime * PI / (2.1 * speed)) + (worldpos.x + d0) * 0.025 + (worldpos.z + d1) * 0.025 - (worldpos.y)) * magnitude * (jellyBounce / 16.0);
		position.z += sin((jellyTime * PI / (2.2 * speed)) + (worldpos.z + d2) * 0.025 + (worldpos.x + d3) * 0.025 - (worldpos.y)) * magnitude * (jellyBounce / 16.0);
		position.y += sin((jellyTime * PI / (2.0 * speed)) + (worldpos.x + d2) * 0.225 + (worldpos.z + d3) * 0.225 - (worldpos.y)) * magnitude * 1.5 * (jellyBounce / 16.0);
	}
#endif

#ifndef FAST_JELLY
#ifdef WAVING_GRASS	
//Grass//
	if (mc_Entity.x == 31.0 && istopv) {
		float speed = 0.01 * 4.0;

		float magnitude = sin((jellyTime * PI / (0.3)) + worldpos.x + worldpos.z) * 0.1 + 0.1;
		float d0 = sin(jellyTime * PI / (222.0 * speed)) * 3.0 - 1.5 + worldpos.z;
		float d1 = sin(jellyTime * PI / (252.0 * speed)) * 3.0 - 1.5 + worldpos.x;
		float d2 = sin(jellyTime * PI / (222.0 * speed)) * 3.0 - 1.5 + worldpos.x;
		float d3 = sin(jellyTime * PI / (252.0 * speed)) * 3.0 - 1.5 + worldpos.z;
		position.x += sin((jellyTime * PI / (28.0 * speed)) + (worldpos.x + d0) * 0.1 + (worldpos.z + d1) * 0.1) * magnitude * (jellyRoll / 16.0);
		position.z += sin((jellyTime * PI / (28.0 * speed)) + (worldpos.z + d2) * 0.1 + (worldpos.x + d3) * 0.1) * magnitude * (jellyRoll / 16.0);
	}

	//small leaf movement
	if (mc_Entity.x == 31.0 && istopv) {
		float speed = 0.01 * 4.0;

		float magnitude = (sin(((worldpos.y + worldpos.x) / 2.0 + jellyTime * PI / ((0.3)))) * 0.05 + 0.15) * 0.5;
		float d0 = sin(jellyTime * PI / (312.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(jellyTime * PI / (342.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(jellyTime * PI / (312.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(jellyTime * PI / (342.0 * speed)) * 3.0 - 1.5;
		position.x += sin((jellyTime * PI / (18.0 * speed)) + (-worldpos.x + d0) * 1.6 + (worldpos.z + d1) * 1.6) * magnitude * (jellyRoll / 16.0);
		position.z += sin((jellyTime * PI / (18.0 * speed)) + (worldpos.z + d2) * 1.6 + (-worldpos.x + d3) * 1.6) * magnitude * (jellyRoll / 16.0);
		position.y += sin((jellyTime * PI / (11.0 * speed)) + (worldpos.z + d2) + (worldpos.x + d3)) * (magnitude / 3.0) * (jellyRoll / 16.0);
	}

#endif


#ifdef WAVING_SAPLINGS
//Grass//
	if (mc_Entity.x == 06.0 && istopv) {
		float speed = 0.01 * 4.0;

		float magnitude = sin((jellyTime * PI / (0.3)) + worldpos.x + worldpos.z) * 0.1 + 0.1;
		float d0 = sin(jellyTime * PI / (222.0 * speed)) * 3.0 - 1.5 + worldpos.z;
		float d1 = sin(jellyTime * PI / (252.0 * speed)) * 3.0 - 1.5 + worldpos.x;
		float d2 = sin(jellyTime * PI / (222.0 * speed)) * 3.0 - 1.5 + worldpos.x;
		float d3 = sin(jellyTime * PI / (252.0 * speed)) * 3.0 - 1.5 + worldpos.z;
		position.x += sin((jellyTime * PI / (28.0 * speed)) + (worldpos.x + d0) * 0.1 + (worldpos.z + d1) * 0.1) * magnitude * (jellyRoll / 16.0);
		position.z += sin((jellyTime * PI / (28.0 * speed)) + (worldpos.z + d2) * 0.1 + (worldpos.x + d3) * 0.1) * magnitude * (jellyRoll / 16.0);
	}

	//small leaf movement
	if (mc_Entity.x == 06.0 && istopv) {
		float speed = 0.01 * 4.0;

		float magnitude = (sin(((worldpos.y + worldpos.x) / 2.0 + jellyTime * PI / ((0.3)))) * 0.05 + 0.15) * 0.5;
		float d0 = sin(jellyTime * PI / (312.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(jellyTime * PI / (342.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(jellyTime * PI / (312.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(jellyTime * PI / (342.0 * speed)) * 3.0 - 1.5;
		position.x += sin((jellyTime * PI / (18.0 * speed)) + (-worldpos.x + d0) * 1.6 + (worldpos.z + d1) * 1.6) * magnitude * (jellyRoll / 16.0);
		position.z += sin((jellyTime * PI / (18.0 * speed)) + (worldpos.z + d2) * 1.6 + (-worldpos.x + d3) * 1.6) * magnitude * (jellyRoll / 16.0);
		position.y += sin((jellyTime * PI / (11.0 * speed)) + (worldpos.z + d2) + (worldpos.x + d3)) * (magnitude/3.0) * (jellyRoll / 16.0);
	}
#endif


#ifdef WAVING_DEAD_BUSH
//Grass//
	if (mc_Entity.x == 32.0 && istopv) {
		float speed = 0.01 * 4.0;

		float magnitude = sin((jellyTime * PI / (0.3)) + worldpos.x + worldpos.z) * 0.1 + 0.1;
		float d0 = sin(jellyTime * PI / (222.0 * speed)) * 3.0 - 1.5 + worldpos.z;
		float d1 = sin(jellyTime * PI / (252.0 * speed)) * 3.0 - 1.5 + worldpos.x;
		float d2 = sin(jellyTime * PI / (222.0 * speed)) * 3.0 - 1.5 + worldpos.x;
		float d3 = sin(jellyTime * PI / (252.0 * speed)) * 3.0 - 1.5 + worldpos.z;
		position.x += sin((jellyTime * PI / (28.0 * speed)) + (worldpos.x + d0) * 0.1 + (worldpos.z + d1) * 0.1) * magnitude * (jellyRoll / 16.0);
		position.z += sin((jellyTime * PI / (28.0 * speed)) + (worldpos.z + d2) * 0.1 + (worldpos.x + d3) * 0.1) * magnitude * (jellyRoll / 16.0);
	}

	//small leaf movement
	if (mc_Entity.x == 32.0 && istopv) {
		float speed = 0.01 * 4.0;

		float magnitude = (sin(((worldpos.y + worldpos.x) / 2.0 + jellyTime * PI / ((0.3)))) * 0.05 + 0.15) * 0.5;
		float d0 = sin(jellyTime * PI / (312.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(jellyTime * PI / (342.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(jellyTime * PI / (312.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(jellyTime * PI / (342.0 * speed)) * 3.0 - 1.5;
		position.x += sin((jellyTime * PI / (18.0 * speed)) + (-worldpos.x + d0) * 1.6 + (worldpos.z + d1) * 1.6) * magnitude * (jellyRoll / 16.0);
		position.z += sin((jellyTime * PI / (18.0 * speed)) + (worldpos.z + d2) * 1.6 + (-worldpos.x + d3) * 1.6) * magnitude * (jellyRoll / 16.0);
		position.y += sin((jellyTime * PI / (11.0 * speed)) + (worldpos.z + d2) + (worldpos.x + d3)) * (magnitude/3.0) * (jellyRoll / 16.0);
	}
#endif


#ifdef WAVING_FLOWERS
	//large scale movement (dandelions)
	if (mc_Entity.x == 37.0 && istopv) {
		float speed = 1.01;
		float magnitude = sin((jellyTime * PI / (0.3)) + worldpos.x + worldpos.z) * 0.1 + 0.1;
		float d0 = sin(jellyTime * PI / (222.0 * speed)) * 3.0 - 1.5 + worldpos.z;
		float d1 = sin(jellyTime * PI / (252.0 * speed)) * 3.0 - 1.5 + worldpos.x;
		float d2 = sin(jellyTime * PI / (222.0 * speed)) * 3.0 - 1.5 + worldpos.x;
		float d3 = sin(jellyTime * PI / (252.0 * speed)) * 3.0 - 1.5 + worldpos.z;
		position.x += sin((jellyTime * PI / (28.0 * speed)) + (worldpos.x + d0) * 0.1 + (worldpos.z + d1) * 0.1) * magnitude * (jellyRoll / 16.0);
		position.z += sin((jellyTime * PI / (28.0 * speed)) + (worldpos.z + d2) * 0.1 + (worldpos.x + d3) * 0.1) * magnitude * (jellyRoll / 16.0);
	}
	//small scale movement (dandelions)
	if (mc_Entity.x == 37.0 && istopv) {
		float speed = 1.01;
		float magnitude = (sin(((worldpos.y + worldpos.x) / 2.0 + jellyTime * PI / ((0.3)))) * 0.05 + 0.15) * 0.5;
		float d0 = sin(jellyTime * PI / (212.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(jellyTime * PI / (242.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(jellyTime * PI / (212.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(jellyTime * PI / (242.0 * speed)) * 3.0 - 1.5;
		position.x += sin((jellyTime * PI / (18.0 * speed)) + (-worldpos.x + d0) * 1.6 + (worldpos.z + d1) * 1.6) * magnitude * (jellyRoll / 16.0);
		position.z += sin((jellyTime * PI / (18.0 * speed)) + (worldpos.z + d2) * 1.6 + (-worldpos.x + d3) * 1.6) * magnitude * (jellyRoll / 16.0);
		position.y += sin((jellyTime * PI / (11.0 * speed)) + (worldpos.z + d2) + (worldpos.x + d3)) * (magnitude/3.0) * (jellyRoll / 16.0);
	}
	//large scale movement (roses)
	if (mc_Entity.x == 38.0 && istopv) {
		float speed = 1.01;
		float magnitude = sin((jellyTime * PI / (0.3)) + worldpos.x + worldpos.z) * 0.1 + 0.1;
		float d0 = sin(jellyTime * PI / (222.0 * speed)) * 3.0 - 1.5 + worldpos.z;
		float d1 = sin(jellyTime * PI / (252.0 * speed)) * 3.0 - 1.5 + worldpos.x;
		float d2 = sin(jellyTime * PI / (222.0 * speed)) * 3.0 - 1.5 + worldpos.x;
		float d3 = sin(jellyTime * PI / (252.0 * speed)) * 3.0 - 1.5 + worldpos.z;
		position.x += sin((jellyTime * PI / (28.0 * speed)) + (worldpos.x + d0) * 0.1 + (worldpos.z + d1) * 0.1) * magnitude * (jellyRoll / 16.0);
		position.z += sin((jellyTime * PI / (28.0 * speed)) + (worldpos.z + d2) * 0.1 + (worldpos.x + d3) * 0.1) * magnitude * (jellyRoll / 16.0);
	}
	//small scale movement (roses)
	if (mc_Entity.x == 38.0 && istopv) {
		float speed = 1.01;
		float magnitude = (sin(((worldpos.y + worldpos.x) / 2.0 + jellyTime * PI / ((0.3)))) * 0.05 + 0.15) * 0.5;
		float d0 = sin(jellyTime * PI / (212.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(jellyTime * PI / (242.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(jellyTime * PI / (212.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(jellyTime * PI / (242.0 * speed)) * 3.0 - 1.5;
		position.x += sin((jellyTime * PI / (18.0 * speed)) + (-worldpos.x + d0) * 1.6 + (worldpos.z + d1) * 1.6) * magnitude * (jellyRoll / 16.0);
		position.z += sin((jellyTime * PI / (18.0 * speed)) + (worldpos.z + d2) * 1.6 + (-worldpos.x + d3) * 1.6) * magnitude * (jellyRoll / 16.0);
		position.y += sin((jellyTime * PI / (11.0 * speed)) + (worldpos.z + d2) + (worldpos.x + d3)) * (magnitude/3.0) * (jellyRoll / 16.0);
	}
	#endif


#ifdef WAVING_WHEAT
//Wheat//
	if (mc_Entity.x == 59.0 && istopv) {
		float speed = 0.01 * 4.0;

		float magnitude = sin((jellyTime * PI / (0.3)) + worldpos.x + worldpos.z) * 0.12 + 0.12;
		float d0 = sin(jellyTime * PI / (222.0 * speed)) * 3.0 - 1.5 + worldpos.z;
		float d1 = sin(jellyTime * PI / (252.0 * speed)) * 3.0 - 1.5 + worldpos.x;
		float d2 = sin(jellyTime * PI / (222.0 * speed)) * 3.0 - 1.5 + worldpos.x;
		float d3 = sin(jellyTime * PI / (252.0 * speed)) * 3.0 - 1.5 + worldpos.z;
		position.x += sin((jellyTime * PI / (28.0 * speed)) + (worldpos.x + d0) * 0.1 + (worldpos.z + d1) * 0.1) * magnitude * (jellyRoll / 16.0);
		position.z += sin((jellyTime * PI / (28.0 * speed)) + (worldpos.z + d2) * 0.1 + (worldpos.x + d3) * 0.1) * magnitude * (jellyRoll / 16.0);
	}

	//small leaf movement
	if (mc_Entity.x == 59.0 && istopv) {
		float speed = 0.01 * 4.0;

		float magnitude = (sin(((worldpos.y + worldpos.x) / 2.0 + jellyTime * PI / ((0.3)))) * 0.035 + 0.085) * 0.3;
		float d0 = sin(jellyTime * PI / (212.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(jellyTime * PI / (242.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(jellyTime * PI / (212.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(jellyTime * PI / (242.0 * speed)) * 3.0 - 1.5;
		position.x += sin((jellyTime * PI / (18.0 * speed)) + (-worldpos.x + d0) * 1.6 + (worldpos.z + d1) * 1.6) * magnitude * (jellyRoll / 16.0);
		position.z += sin((jellyTime * PI / (18.0 * speed)) + (worldpos.z + d2) * 1.6 + (-worldpos.x + d3) * 1.6) * magnitude * (jellyRoll / 16.0);
		position.y += sin((jellyTime * PI / (11.0 * speed)) + (worldpos.z + d2) + (worldpos.x + d3)) * (magnitude/3.0) * (jellyRoll / 16.0);
	}
#endif


#ifdef WAVING_WART
//Wheat//
	if (mc_Entity.x == 115.0 && istopv) {
		float speed = 0.01 * 4.0;

		float magnitude = sin((jellyTime * PI / (0.3)) + worldpos.x + worldpos.z) * 0.12 + 0.12;
		float d0 = sin(jellyTime * PI / (222.0 * speed)) * 3.0 - 1.5 + worldpos.z;
		float d1 = sin(jellyTime * PI / (252.0 * speed)) * 3.0 - 1.5 + worldpos.x;
		float d2 = sin(jellyTime * PI / (222.0 * speed)) * 3.0 - 1.5 + worldpos.x;
		float d3 = sin(jellyTime * PI / (252.0 * speed)) * 3.0 - 1.5 + worldpos.z;
		position.x += sin((jellyTime * PI / (28.0 * speed)) + (worldpos.x + d0) * 0.1 + (worldpos.z + d1) * 0.1) * magnitude * (jellyRoll / 16.0);
		position.z += sin((jellyTime * PI / (28.0 * speed)) + (worldpos.z + d2) * 0.1 + (worldpos.x + d3) * 0.1) * magnitude * (jellyRoll / 16.0);
	}

	//small leaf movement
	if (mc_Entity.x == 115.0 && istopv) {
		float speed = 0.01 * 4.0;

		float magnitude = (sin(((worldpos.y + worldpos.x) / 2.0 + jellyTime * PI / ((0.3)))) * 0.035 + 0.085) * 0.3;
		float d0 = sin(jellyTime * PI / (212.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(jellyTime * PI / (242.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(jellyTime * PI / (212.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(jellyTime * PI / (242.0 * speed)) * 3.0 - 1.5;
		position.x += sin((jellyTime * PI / (18.0 * speed)) + (-worldpos.x + d0) * 1.6 + (worldpos.z + d1) * 1.6) * magnitude * (jellyRoll / 16.0);
		position.z += sin((jellyTime * PI / (18.0 * speed)) + (worldpos.z + d2) * 1.6 + (-worldpos.x + d3) * 1.6) * magnitude * (jellyRoll / 16.0);
		position.y += sin((jellyTime * PI / (11.0 * speed)) + (worldpos.z + d2) + (worldpos.x + d3)) * (magnitude / 3.0) * (jellyRoll / 16.0);
	}
#endif


#ifdef WAVING_LEAVES
	//large scale movement
	if (mc_Entity.x == 18.0 || mc_Entity.x == 161.0) {
		float speed = 0.06;
		float magnitude = (sin(((worldpos.y + worldpos.x + worldpos.z) / 1.0 + jellyTime * PI / ((0.5)))) * 0.05 + 0.15) * 0.27;
		#ifdef LITERAL_JELLY_MODE
		position.x += cos((jellyTime * PI / (2.0 * speed)) + (worldpos.x) * 0.1 + (worldpos.z) * 0.1 + (worldpos.y)) * magnitude * (jellyBounce / 32.0);
		position.z += cos((jellyTime * PI / (2.6 * speed)) + (worldpos.z) * 0.1 + (worldpos.x) * 0.1 + (worldpos.y)) * magnitude * (jellyBounce / 32.0);
		position.y += cos((jellyTime * PI / (2.4 * speed)) + (worldpos.x) * 0.9 + (worldpos.z) * 0.9 + (worldpos.y)) * magnitude * 2.0 * (jellyBounce / 48.0);
		#else
		position.x += cos((jellyTime * PI / (2.0 * speed)) + (worldpos.x) * 0.1 + (worldpos.z) * 0.1 + (worldpos.y)) * magnitude * (jellyBounce / 12.0);
		position.z += cos((jellyTime * PI / (2.6 * speed)) + (worldpos.z) * 0.1 + (worldpos.x) * 0.1 + (worldpos.y)) * magnitude * (jellyBounce / 12.0);
		position.y += cos((jellyTime * PI / (2.4 * speed)) + (worldpos.x) * 0.9 + (worldpos.z) * 0.9 + (worldpos.y)) * magnitude * 2.0 * (jellyBounce / 42.0);
		#endif
	}
#endif


#ifdef WAVING_VINES
	//large scale movement
	if (mc_Entity.x == 106.0) {
		float speed = 0.06;
		float magnitude = (sin(((worldpos.y + worldpos.x + worldpos.z) / 1.0 + (jellyTime + 0.03) * PI / ((0.3)))) * 0.05 + 0.15) * 0.27;
		#ifdef LITERAL_JELLY_MODE
		position.x += cos(((jellyTime + 0.03) * PI / (2.0 * speed)) + (worldpos.x) * 0.1 + (worldpos.z) * 0.1 + (worldpos.y)) * magnitude * (jellyBounce / 32.0);
		position.z += cos(((jellyTime + 0.03) * PI / (2.6 * speed)) + (worldpos.z) * 0.1 + (worldpos.x) * 0.1 + (worldpos.y)) * magnitude * (jellyBounce / 32.0);
		position.y += cos(((jellyTime + 0.03) * PI / (2.4 * speed)) + (worldpos.x) * 0.9 + (worldpos.z) * 0.9 + (worldpos.y)) * magnitude * (jellyBounce / 32.0);
		#else
		position.x += cos(((jellyTime + 0.03) * PI / (2.0 * speed)) + (worldpos.x) * 0.1 + (worldpos.z) * 0.1 + (worldpos.y)) * magnitude * (jellyBounce / 25.0);
		position.z += cos(((jellyTime + 0.03) * PI / (2.6 * speed)) + (worldpos.z) * 0.1 + (worldpos.x) * 0.1 + (worldpos.y)) * magnitude * (jellyBounce / 25.0);
		position.y += cos(((jellyTime + 0.03) * PI / (2.4 * speed)) + (worldpos.x) * 0.9 + (worldpos.z) * 0.9 + (worldpos.y)) * magnitude * (jellyBounce / 25.0);
		#endif
		position.y -= 0.085;
	}
#endif


#ifdef WAVING_SUGAR_CANE
	//large scale movement
	if (mc_Entity.x == 83.0) {
		float speed = 0.06;
		float magnitude = (sin(((worldpos.y + worldpos.x + worldpos.z) / 1.0 + (jellyTime + 0.03) * PI / ((0.3)))) * 0.05 + 0.15) * 0.27;
		position.x += cos(((jellyTime + 0.04) * PI / (2.0 * speed)) + (worldpos.x) * 0.1 + (worldpos.z) * 0.1 + (-worldpos.y)) * magnitude * (jellyBounce / 16.0);
		position.z += cos(((jellyTime + 0.04) * PI / (2.6 * speed)) + (worldpos.z) * 0.1 + (worldpos.x) * 0.1 + (-worldpos.y)) * magnitude * (jellyBounce / 16.0);
		position.y += cos(((jellyTime + 0.04) * PI / (2.4 * speed)) + (worldpos.x) * 0.9 + (worldpos.z) * 0.9 + (-worldpos.y)) * magnitude * (jellyBounce / 16.0);
	}
#endif


#ifdef WAVING_LARGE_FLOWERS
	//large scale movement
	if (mc_Entity.x == 175.0) {
		float speed = 0.06;
		float magnitude = (sin(((worldpos.y + worldpos.x + worldpos.z) / 1.0 + (jellyTime + 0.03) * PI / ((0.3)))) * 0.05 + 0.15) * 0.27;
		position.x += cos(((jellyTime + 0.02) * PI / (2.0 * speed)) + (worldpos.x) * 0.1 + (worldpos.z) * 0.1 + (-worldpos.y)) * magnitude * (jellyBounce / 16.0);
		position.z += cos(((jellyTime + 0.02) * PI / (2.6 * speed)) + (worldpos.z) * 0.1 + (worldpos.x) * 0.1 + (-worldpos.y)) * magnitude * (jellyBounce / 16.0);
		position.y += cos(((jellyTime + 0.02) * PI / (2.4 * speed)) + (worldpos.x) * 0.9 + (worldpos.z) * 0.9 + (-worldpos.y)) * magnitude * (jellyBounce / 16.0);
	}
#endif


#ifdef WAVING_COBWEBS
	//large scale movement
	if (mc_Entity.x == 30.0) {
		float speed = 0.06;
		float magnitude = (sin(((worldpos.y + worldpos.x + worldpos.z) / 1.0 + jellyTime * PI / (0.5)))) * 0.07;
		float d0 = sin(jellyTime * PI / (64.2 * speed)) * 2.0 - 1.5;
		float d1 = sin(jellyTime * PI / (64.1 * speed)) * 2.0 - 1.5;
		float d2 = sin(jellyTime * PI / (64.0 * speed)) * 2.0 - 1.5;
		float d3 = sin(jellyTime * PI / (64.3 * speed)) * 2.0 - 1.5;
		position.x += sin((jellyTime * PI / (2.0 * speed)) + (worldpos.x + d0) * 0.1 + (worldpos.z + d1) * 0.1 + (worldpos.y)) * magnitude * (jellyBounce / 16.0);
		position.z += sin((jellyTime * PI / (2.6 * speed)) + (worldpos.z + d2) * 0.1 + (worldpos.x + d3) * 0.1 + (worldpos.y)) * magnitude * (jellyBounce / 16.0);
		position.y += sin((jellyTime * PI / (2.4 * speed)) + (worldpos.x + d2) * 0.9 + (worldpos.z + d3) * 0.9 + (worldpos.y)) * magnitude * 2.0 * (jellyBounce / 16.0);
	}
#endif
#endif

//A jelly-like block that wobbles in a world that's shaking and wobbling like a jelly? Jellyception, anyone?
#ifdef WAVING_SLIME_BLOCKS
	//large scale movement
	if (mc_Entity.x == 165.0) {
		float speed = 0.06;
		float magnitude = (sin(((worldpos.y + worldpos.x + worldpos.z) / 1.0 + jellyTime * PI / (0.5)))) * 0.08;
		float d0 = sin(jellyTime * PI / (64.2 * speed)) * 2.0 - 1.5;
		float d1 = sin(jellyTime * PI / (64.1 * speed)) * 2.0 - 1.5;
		float d2 = sin(jellyTime * PI / (64.0 * speed)) * 2.0 - 1.5;
		float d3 = sin(jellyTime * PI / (64.3 * speed)) * 2.0 - 1.5;
		#ifdef LITERAL_JELLY_MODE
		position.x += sin((jellyTime * PI / (2.1 * speed)) + (worldpos.x + d0) * 0.1 + (worldpos.z + d1) * 0.1 - (worldpos.y)) * magnitude * (jellyBounce / 36.0);
		position.z += sin((jellyTime * PI / (2.2 * speed)) + (worldpos.z + d2) * 0.1 + (worldpos.x + d3) * 0.1 - (worldpos.y)) * magnitude * (jellyBounce / 36.0);
		position.y += sin((jellyTime * PI / (2.0 * speed)) + (worldpos.x + d2) * 0.9 + (worldpos.z + d3) * 0.9 - (worldpos.y)) * magnitude * 0.8 * (jellyBounce / 36.0);
		#else
		position.x += sin((jellyTime * PI / (2.1 * speed)) + (worldpos.x + d0) * 0.1 + (worldpos.z + d1) * 0.1 - (worldpos.y)) * magnitude * (jellyBounce / 24.0);
		position.z += sin((jellyTime * PI / (2.2 * speed)) + (worldpos.z + d2) * 0.1 + (worldpos.x + d3) * 0.1 - (worldpos.y)) * magnitude * (jellyBounce / 24.0);
		position.y += sin((jellyTime * PI / (2.0 * speed)) + (worldpos.x + d2) * 0.9 + (worldpos.z + d3) * 0.9 - (worldpos.y)) * magnitude * 0.8 * (jellyBounce / 24.0);
		#endif
	}
#endif

	}

	position = gbufferModelView * position;

	gl_Position = gl_ProjectionMatrix * position;

	color = gl_Color;

	texcoord = gl_TextureMatrix[0] * gl_MultiTexCoord0;

	lmcoord = gl_TextureMatrix[1] * gl_MultiTexCoord1;

	gl_FogFragCoord = gl_Position.z;
}