/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.altmanager.screens;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringJoiner;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_403;
import net.minecraft.class_4068;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9801;
import net.wurstclient.WurstClient;
import net.wurstclient.altmanager.Alt;
import net.wurstclient.altmanager.AltManager;
import net.wurstclient.altmanager.AltRenderer;
import net.wurstclient.altmanager.AltsFile;
import net.wurstclient.altmanager.CrackedAlt;
import net.wurstclient.altmanager.ExportAltsFileChooser;
import net.wurstclient.altmanager.ImportAltsFileChooser;
import net.wurstclient.altmanager.LoginException;
import net.wurstclient.altmanager.MojangAlt;
import net.wurstclient.altmanager.NameGenerator;
import net.wurstclient.altmanager.screens.AddAltScreen;
import net.wurstclient.altmanager.screens.DirectLoginScreen;
import net.wurstclient.altmanager.screens.EditAltScreen;
import net.wurstclient.util.ListWidget;
import net.wurstclient.util.MultiProcessingUtils;
import net.wurstclient.util.json.JsonException;
import net.wurstclient.util.json.JsonUtils;
import net.wurstclient.util.json.WsonObject;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public final class AltManagerScreen
extends class_437 {
    private static final HashSet<Alt> failedLogins = new HashSet();
    private final class_437 prevScreen;
    private final AltManager altManager;
    private ListGui listGui;
    private boolean shouldAsk = true;
    private int errorTimer;
    private class_4185 useButton;
    private class_4185 starButton;
    private class_4185 editButton;
    private class_4185 deleteButton;
    private class_4185 importButton;
    private class_4185 exportButton;

    public AltManagerScreen(class_437 prevScreen, AltManager altManager) {
        super((class_2561)class_2561.method_43470((String)"Alt Manager"));
        this.prevScreen = prevScreen;
        this.altManager = altManager;
    }

    public void method_25426() {
        this.listGui = new ListGui(this.field_22787, this, this.altManager.getList());
        WurstClient wurst = WurstClient.INSTANCE;
        Exception folderException = this.altManager.getFolderException();
        if (folderException != null && this.shouldAsk) {
            class_5250 title = class_2561.method_43470((String)wurst.translate("gui.wurst.altmanager.folder_error.title", new Object[0]));
            class_5250 message = class_2561.method_43470((String)wurst.translate("gui.wurst.altmanager.folder_error.message", folderException));
            class_5250 buttonText = class_2561.method_43471((String)"gui.done");
            Runnable action = () -> this.confirmGenerate(false);
            class_403 screen = new class_403(action, (class_2561)title, (class_2561)message, (class_2561)buttonText, false);
            this.field_22787.method_1507((class_437)screen);
        } else if (this.altManager.getList().isEmpty() && this.shouldAsk) {
            class_5250 title = class_2561.method_43470((String)wurst.translate("gui.wurst.altmanager.empty.title", new Object[0]));
            class_5250 message = class_2561.method_43470((String)wurst.translate("gui.wurst.altmanager.empty.message", new Object[0]));
            BooleanConsumer callback = this::confirmGenerate;
            class_410 screen = new class_410(callback, (class_2561)title, (class_2561)message);
            this.field_22787.method_1507((class_437)screen);
        }
        this.useButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Login"), b -> this.pressLogin()).method_46434(this.field_22789 / 2 - 154, this.field_22790 - 52, 100, 20).method_46431();
        this.method_37063((class_364)this.useButton);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Direct Login"), b -> this.field_22787.method_1507((class_437)new DirectLoginScreen(this))).method_46434(this.field_22789 / 2 - 50, this.field_22790 - 52, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Add"), b -> this.field_22787.method_1507((class_437)new AddAltScreen((class_437)this, this.altManager))).method_46434(this.field_22789 / 2 + 54, this.field_22790 - 52, 100, 20).method_46431());
        this.starButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Favorite"), b -> this.pressFavorite()).method_46434(this.field_22789 / 2 - 154, this.field_22790 - 28, 75, 20).method_46431();
        this.method_37063((class_364)this.starButton);
        this.editButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Edit"), b -> this.pressEdit()).method_46434(this.field_22789 / 2 - 76, this.field_22790 - 28, 74, 20).method_46431();
        this.method_37063((class_364)this.editButton);
        this.deleteButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Delete"), b -> this.pressDelete()).method_46434(this.field_22789 / 2 + 2, this.field_22790 - 28, 74, 20).method_46431();
        this.method_37063((class_364)this.deleteButton);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), b -> this.field_22787.method_1507(this.prevScreen)).method_46434(this.field_22789 / 2 + 80, this.field_22790 - 28, 75, 20).method_46431());
        this.importButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Import"), b -> this.pressImportAlts()).method_46434(8, 8, 50, 20).method_46431();
        this.method_37063((class_364)this.importButton);
        this.exportButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Export"), b -> this.pressExportAlts()).method_46434(58, 8, 50, 20).method_46431();
        this.method_37063((class_364)this.exportButton);
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        this.listGui.method_25402(mouseX, mouseY, mouseButton);
        if (mouseY >= 36.0 && mouseY <= (double)(this.field_22790 - 57) && (mouseX >= (double)(this.field_22789 / 2 + 140) || mouseX <= (double)(this.field_22789 / 2 - 126))) {
            this.listGui.selected = -1;
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.listGui.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.listGui.method_25406(mouseX, mouseY, button);
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        this.listGui.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257) {
            this.useButton.method_25306();
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25393() {
        boolean windowMode;
        boolean altSelected;
        this.useButton.field_22763 = altSelected = this.listGui.selected >= 0 && this.listGui.selected < this.altManager.getList().size();
        this.starButton.field_22763 = altSelected;
        this.editButton.field_22763 = altSelected;
        this.deleteButton.field_22763 = altSelected;
        this.importButton.field_22763 = windowMode = (Boolean)this.field_22787.field_1690.method_42447().method_41753() == false;
        this.exportButton.field_22763 = windowMode;
    }

    private void pressLogin() {
        Alt alt = this.listGui.getSelectedAlt();
        if (alt == null) {
            return;
        }
        try {
            this.altManager.login(alt);
            failedLogins.remove(alt);
            this.field_22787.method_1507(this.prevScreen);
        }
        catch (LoginException e) {
            this.errorTimer = 8;
            failedLogins.add(alt);
        }
    }

    private void pressFavorite() {
        Alt alt = this.listGui.getSelectedAlt();
        if (alt == null) {
            return;
        }
        this.altManager.toggleFavorite(alt);
        this.listGui.selected = -1;
    }

    private void pressEdit() {
        Alt alt = this.listGui.getSelectedAlt();
        if (alt == null) {
            return;
        }
        this.field_22787.method_1507((class_437)new EditAltScreen(this, this.altManager, alt));
    }

    private void pressDelete() {
        Alt alt = this.listGui.getSelectedAlt();
        if (alt == null) {
            return;
        }
        class_5250 text = class_2561.method_43470((String)"Are you sure you want to remove this alt?");
        String altName = alt.getDisplayName();
        class_5250 message = class_2561.method_43470((String)("\"" + altName + "\" will be lost forever! (A long time!)"));
        class_410 screen = new class_410(this::confirmRemove, (class_2561)text, (class_2561)message, (class_2561)class_2561.method_43470((String)"Delete"), (class_2561)class_2561.method_43470((String)"Cancel"));
        this.field_22787.method_1507((class_437)screen);
    }

    private void pressImportAlts() {
        try {
            Process process = MultiProcessingUtils.startProcessWithIO(ImportAltsFileChooser.class, WurstClient.INSTANCE.getWurstFolder().toString());
            Path path = this.getFileChooserPath(process);
            process.waitFor();
            if (path.getFileName().toString().endsWith(".json")) {
                this.importAsJSON(path);
            } else {
                this.importAsTXT(path);
            }
        }
        catch (IOException | InterruptedException | JsonException e) {
            e.printStackTrace();
        }
    }

    private void importAsJSON(Path path) throws IOException, JsonException {
        WsonObject wson = JsonUtils.parseFileToObject(path);
        ArrayList<Alt> alts = AltsFile.parseJson(wson);
        this.altManager.addAll(alts);
    }

    private void importAsTXT(Path path) throws IOException {
        List<String> lines = Files.readAllLines(path);
        ArrayList<Alt> alts = new ArrayList<Alt>();
        for (String line : lines) {
            String[] data = line.split(":");
            switch (data.length) {
                case 1: {
                    alts.add(new CrackedAlt(data[0]));
                    break;
                }
                case 2: {
                    alts.add(new MojangAlt(data[0], data[1]));
                }
            }
        }
        this.altManager.addAll(alts);
    }

    private void pressExportAlts() {
        try {
            Process process = MultiProcessingUtils.startProcessWithIO(ExportAltsFileChooser.class, WurstClient.INSTANCE.getWurstFolder().toString());
            Path path = this.getFileChooserPath(process);
            process.waitFor();
            if (path.getFileName().toString().endsWith(".json")) {
                this.exportAsJSON(path);
            } else {
                this.exportAsTXT(path);
            }
        }
        catch (IOException | InterruptedException | JsonException e) {
            e.printStackTrace();
        }
    }

    private Path getFileChooserPath(Process process) throws IOException {
        try (BufferedReader bf = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
            String response = bf.readLine();
            if (response == null) {
                throw new IOException("No reponse from FileChooser");
            }
            try {
                Path path = Paths.get(response, new String[0]);
                return path;
            }
            catch (InvalidPathException e) {
                throw new IOException("Reponse from FileChooser is not a valid path");
            }
        }
    }

    private void exportAsJSON(Path path) throws IOException, JsonException {
        JsonObject json = AltsFile.createJson(this.altManager);
        JsonUtils.toJson((JsonElement)json, path);
    }

    private void exportAsTXT(Path path) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        for (Alt alt : this.altManager.getList()) {
            lines.add(alt.exportAsTXT());
        }
        Files.write(path, lines, new OpenOption[0]);
    }

    private void confirmGenerate(boolean confirmed) {
        if (confirmed) {
            ArrayList<Alt> alts = new ArrayList<Alt>();
            for (int i = 0; i < 8; ++i) {
                alts.add(new CrackedAlt(NameGenerator.generateName()));
            }
            this.altManager.addAll(alts);
        }
        this.shouldAsk = false;
        this.field_22787.method_1507((class_437)this);
    }

    private void confirmRemove(boolean confirmed) {
        if (this.listGui.getSelectedAlt() == null) {
            return;
        }
        if (confirmed) {
            this.altManager.remove(this.listGui.selected);
        }
        this.field_22787.method_1507((class_437)this);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(context, mouseX, mouseY, partialTicks);
        this.listGui.method_25394(context, mouseX, mouseY, partialTicks);
        class_4587 matrixStack = context.method_51448();
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        RenderSystem.setShader((class_10156)class_10142.field_53875);
        if (this.listGui.getSelectedSlot() != -1 && this.listGui.getSelectedSlot() < this.altManager.getList().size()) {
            Alt alt = this.listGui.getSelectedAlt();
            if (alt == null) {
                return;
            }
            AltRenderer.drawAltBack(context, alt.getName(), (this.field_22789 / 2 - 125) / 2 - 32, this.field_22790 / 2 - 64 - 9, 64, 128);
            AltRenderer.drawAltBody(context, alt.getName(), this.field_22789 - (this.field_22789 / 2 - 140) / 2 - 32, this.field_22790 / 2 - 64 - 9, 64, 128);
        }
        context.method_25300(this.field_22793, "Alt Manager", this.field_22789 / 2, 4, 0xFFFFFF);
        context.method_25300(this.field_22793, "Alts: " + this.altManager.getList().size(), this.field_22789 / 2, 14, 0xA0A0A0);
        context.method_25300(this.field_22793, "premium: " + this.altManager.getNumPremium() + ", cracked: " + this.altManager.getNumCracked(), this.field_22789 / 2, 24, 0xA0A0A0);
        if (this.errorTimer > 0) {
            RenderSystem.setShader((class_10156)class_10142.field_53875);
            GL11.glDisable((int)2884);
            GL11.glEnable((int)3042);
            RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)((float)this.errorTimer / 16.0f));
            class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1592);
            bufferBuilder.method_22918(matrix, 0.0f, 0.0f, 0.0f);
            bufferBuilder.method_22918(matrix, (float)this.field_22789, 0.0f, 0.0f);
            bufferBuilder.method_22918(matrix, (float)this.field_22789, (float)this.field_22790, 0.0f);
            bufferBuilder.method_22918(matrix, 0.0f, (float)this.field_22790, 0.0f);
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
            --this.errorTimer;
        }
        for (class_4068 drawable : this.field_33816) {
            drawable.method_25394(context, mouseX, mouseY, partialTicks);
        }
        this.renderButtonTooltip(context, mouseX, mouseY);
        this.renderAltTooltip(context, mouseX, mouseY);
    }

    private void renderAltTooltip(class_332 context, int mouseX, int mouseY) {
        if (!this.listGui.isMouseInList(mouseX, mouseY)) {
            return;
        }
        List<Alt> altList = this.altManager.getList();
        int hoveredIndex = this.listGui.getItemAtPosition(mouseX, mouseY);
        if (hoveredIndex < 0 || hoveredIndex >= altList.size()) {
            return;
        }
        int itemX = mouseX - (this.field_22789 - this.listGui.getRowWidth()) / 2;
        int itemY = mouseY - 36 + (int)this.listGui.getScrollAmount() - 4 - hoveredIndex * 30;
        if (itemX < 31 || itemY < 15 || itemY >= 25) {
            return;
        }
        Alt alt = altList.get(hoveredIndex);
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        if (itemX >= 31 + this.field_22793.method_1727(this.listGui.getBottomText(alt))) {
            return;
        }
        if (alt.isCracked()) {
            this.addTooltip(tooltip, "cracked");
        } else {
            this.addTooltip(tooltip, "premium");
            if (failedLogins.contains(alt)) {
                this.addTooltip(tooltip, "failed");
            }
            if (alt.isCheckedPremium()) {
                this.addTooltip(tooltip, "checked");
            } else {
                this.addTooltip(tooltip, "unchecked");
            }
        }
        if (alt.isFavorite()) {
            this.addTooltip(tooltip, "favorite");
        }
        context.method_51434(this.field_22793, tooltip, mouseX, mouseY);
    }

    private void renderButtonTooltip(class_332 context, int mouseX, int mouseY) {
        for (class_339 button : Screens.getButtons((class_437)this)) {
            if (!button.method_25367() || button != this.importButton && button != this.exportButton) continue;
            ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
            this.addTooltip(tooltip, "window");
            if (((Boolean)this.field_22787.field_1690.method_42447().method_41753()).booleanValue()) {
                this.addTooltip(tooltip, "fullscreen");
            } else {
                this.addTooltip(tooltip, "window_freeze");
            }
            context.method_51434(this.field_22793, tooltip, mouseX, mouseY);
            break;
        }
    }

    private void addTooltip(ArrayList<class_2561> tooltip, String trKey) {
        String translated = WurstClient.INSTANCE.translate("description.wurst.altmanager." + trKey, new Object[0]);
        StringJoiner joiner = new StringJoiner("\n");
        this.field_22793.method_27527().method_27498(translated, 200, class_2583.field_24360).stream().map(class_5348::getString).forEach(s -> joiner.add((CharSequence)s));
        String wrapped = joiner.toString();
        for (String line : wrapped.split("\n")) {
            tooltip.add((class_2561)class_2561.method_43470((String)line));
        }
    }

    public void method_25419() {
        this.field_22787.method_1507(this.prevScreen);
    }

    public static final class ListGui
    extends ListWidget {
        private final List<Alt> list;
        private int selected = -1;
        private AltManagerScreen prevScreen;
        private long lastTime;

        public ListGui(class_310 minecraft, AltManagerScreen prevScreen, List<Alt> list) {
            super(minecraft, prevScreen.field_22789, prevScreen.field_22790, 36, prevScreen.field_22790 - 56, 30);
            this.prevScreen = prevScreen;
            this.list = list;
        }

        @Override
        protected boolean isSelectedItem(int id) {
            return this.selected == id;
        }

        protected int getSelectedSlot() {
            return this.selected;
        }

        protected Alt getSelectedAlt() {
            if (this.selected < 0 || this.selected >= this.list.size()) {
                return null;
            }
            return this.list.get(this.selected);
        }

        @Override
        protected int getItemCount() {
            return this.list.size();
        }

        @Override
        protected boolean selectItem(int index, int button, double mouseX, double mouseY) {
            if (index == this.selected && class_156.method_658() - this.lastTime < 250L) {
                this.prevScreen.pressLogin();
            }
            if (index >= 0 && index < this.list.size()) {
                this.selected = index;
            }
            this.lastTime = class_156.method_658();
            return true;
        }

        @Override
        protected void renderBackground() {
        }

        @Override
        protected void renderItem(class_332 context, int id, int x, int y, int var4, int var5, int var6, float partialTicks) {
            Alt alt = this.list.get(id);
            class_4587 matrixStack = context.method_51448();
            Matrix4f matrix = matrixStack.method_23760().method_23761();
            class_289 tessellator = RenderSystem.renderThreadTesselator();
            RenderSystem.setShader((class_10156)class_10142.field_53875);
            if (this.client.method_1548().method_1676().equals(alt.getName())) {
                GL11.glDisable((int)2884);
                GL11.glEnable((int)3042);
                float opacity = 0.3f - Math.abs(class_3532.method_15374((float)((float)(System.currentTimeMillis() % 10000L) / 10000.0f * (float)Math.PI * 2.0f)) * 0.15f);
                RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)0.0f, (float)opacity);
                class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1592);
                bufferBuilder.method_22918(matrix, (float)(x - 2), (float)(y - 2), 0.0f);
                bufferBuilder.method_22918(matrix, (float)(x - 2 + 220), (float)(y - 2), 0.0f);
                bufferBuilder.method_22918(matrix, (float)(x - 2 + 220), (float)(y - 2 + 30), 0.0f);
                bufferBuilder.method_22918(matrix, (float)(x - 2), (float)(y - 2 + 30), 0.0f);
                class_286.method_43433((class_9801)bufferBuilder.method_60800());
                GL11.glEnable((int)2884);
                GL11.glDisable((int)3042);
            }
            context.method_51452();
            AltRenderer.drawAltFace(context, alt.getName(), x + 1, y + 1, 24, 24, this.isSelectedItem(id));
            context.method_51433(this.client.field_1772, "Name: " + alt.getDisplayName(), x + 31, y + 3, 0xA0A0A0, false);
            context.method_51433(this.client.field_1772, "Name: " + alt.getDisplayName(), x + 31, y + 3, 0xA0A0A0, false);
            String bottomText = this.getBottomText(alt);
            context.method_51433(this.client.field_1772, bottomText, x + 31, y + 15, 0xA0A0A0, false);
        }

        public String getBottomText(Alt alt) {
            Object text;
            Object object = text = alt.isCracked() ? "\u00a78cracked" : "\u00a72premium";
            if (alt.isFavorite()) {
                text = (String)text + "\u00a7r, \u00a7efavorite";
            }
            if (failedLogins.contains(alt)) {
                text = (String)text + "\u00a7r, \u00a7cwrong password?";
            } else if (alt.isUncheckedPremium()) {
                text = (String)text + "\u00a7r, \u00a7cunchecked";
            }
            return text;
        }
    }
}

