/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.clickgui;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_9801;
import net.wurstclient.Category;
import net.wurstclient.Feature;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.Component;
import net.wurstclient.clickgui.Popup;
import net.wurstclient.clickgui.SettingsWindow;
import net.wurstclient.clickgui.Window;
import net.wurstclient.clickgui.components.FeatureButton;
import net.wurstclient.hacks.ClickGuiHack;
import net.wurstclient.settings.Setting;
import net.wurstclient.util.RenderUtils;
import net.wurstclient.util.json.JsonUtils;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public final class ClickGui {
    private static final WurstClient WURST = WurstClient.INSTANCE;
    private static final class_310 MC = WurstClient.MC;
    private final ArrayList<Window> windows = new ArrayList();
    private final ArrayList<Popup> popups = new ArrayList();
    private final Path windowsFile;
    private float[] bgColor = new float[3];
    private float[] acColor = new float[3];
    private int txtColor;
    private float opacity;
    private float ttOpacity;
    private int maxHeight;
    private int maxSettingsHeight;
    private String tooltip = "";
    private boolean leftMouseButtonPressed;

    public ClickGui(Path windowsFile) {
        this.windowsFile = windowsFile;
    }

    public void init() {
        JsonObject json;
        this.updateColors();
        LinkedHashMap<Category, Window> windowMap = new LinkedHashMap<Category, Window>();
        for (Category category : Category.values()) {
            windowMap.put(category, new Window(category.getName()));
        }
        ArrayList<Feature> features = new ArrayList<Feature>();
        features.addAll(WURST.getHax().getAllHax());
        features.addAll(WURST.getCmds().getAllCmds());
        features.addAll(WURST.getOtfs().getAllOtfs());
        for (Feature f : features) {
            if (f.getCategory() == null) continue;
            ((Window)windowMap.get((Object)f.getCategory())).add(new FeatureButton(f));
        }
        this.windows.addAll(windowMap.values());
        Window uiSettings = new Window("UI Settings");
        uiSettings.add(new FeatureButton(ClickGui.WURST.getOtfs().wurstLogoOtf));
        uiSettings.add(new FeatureButton(ClickGui.WURST.getOtfs().hackListOtf));
        uiSettings.add(new FeatureButton(ClickGui.WURST.getOtfs().keybindManagerOtf));
        ClickGuiHack clickGuiHack = ClickGui.WURST.getHax().clickGuiHack;
        Stream<Setting> settings = clickGuiHack.getSettings().values().stream();
        settings.map(Setting::getComponent).forEach(c -> uiSettings.add((Component)c));
        this.windows.add(uiSettings);
        for (Window window : this.windows) {
            window.setMinimized(true);
        }
        this.windows.add(WurstClient.INSTANCE.getHax().radarHack.getWindow());
        int x = 5;
        int y = 5;
        class_1041 sr = MC.method_22683();
        for (Window window : this.windows) {
            window.pack();
            if (x + window.getWidth() + 5 > sr.method_4486()) {
                x = 5;
                y += 18;
            }
            window.setX(x);
            window.setY(y);
            x += window.getWidth() + 5;
        }
        try (BufferedReader reader = Files.newBufferedReader(this.windowsFile);){
            json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
        }
        catch (NoSuchFileException e) {
            this.saveWindows();
            return;
        }
        catch (Exception e) {
            System.out.println("Failed to load " + String.valueOf(this.windowsFile.getFileName()));
            e.printStackTrace();
            this.saveWindows();
            return;
        }
        for (Window window : this.windows) {
            JsonElement jsonPinned;
            JsonElement jsonMinimized;
            JsonElement jsonY;
            JsonElement jsonWindow = json.get(window.getTitle());
            if (jsonWindow == null || !jsonWindow.isJsonObject()) continue;
            JsonElement jsonX = jsonWindow.getAsJsonObject().get("x");
            if (jsonX.isJsonPrimitive() && jsonX.getAsJsonPrimitive().isNumber()) {
                window.setX(jsonX.getAsInt());
            }
            if ((jsonY = jsonWindow.getAsJsonObject().get("y")).isJsonPrimitive() && jsonY.getAsJsonPrimitive().isNumber()) {
                window.setY(jsonY.getAsInt());
            }
            if ((jsonMinimized = jsonWindow.getAsJsonObject().get("minimized")).isJsonPrimitive() && jsonMinimized.getAsJsonPrimitive().isBoolean()) {
                window.setMinimized(jsonMinimized.getAsBoolean());
            }
            if (!(jsonPinned = jsonWindow.getAsJsonObject().get("pinned")).isJsonPrimitive() || !jsonPinned.getAsJsonPrimitive().isBoolean()) continue;
            window.setPinned(jsonPinned.getAsBoolean());
        }
        this.saveWindows();
    }

    private void saveWindows() {
        JsonObject json = new JsonObject();
        for (Window window : this.windows) {
            if (window.isClosable()) continue;
            JsonObject jsonWindow = new JsonObject();
            jsonWindow.addProperty("x", (Number)window.getActualX());
            jsonWindow.addProperty("y", (Number)window.getActualY());
            jsonWindow.addProperty("minimized", Boolean.valueOf(window.isMinimized()));
            jsonWindow.addProperty("pinned", Boolean.valueOf(window.isPinned()));
            json.add(window.getTitle(), (JsonElement)jsonWindow);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.windowsFile, new OpenOption[0]);){
            JsonUtils.PRETTY_GSON.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (IOException e) {
            System.out.println("Failed to save " + String.valueOf(this.windowsFile.getFileName()));
            e.printStackTrace();
        }
    }

    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        boolean popupClicked;
        if (mouseButton == 0) {
            this.leftMouseButtonPressed = true;
        }
        if (!(popupClicked = this.handlePopupMouseClick(mouseX, mouseY, mouseButton))) {
            this.handleWindowMouseClick(mouseX, mouseY, mouseButton);
        }
        for (Popup popup : this.popups) {
            if (!popup.getOwner().getParent().isClosing()) continue;
            popup.close();
        }
        this.windows.removeIf(Window::isClosing);
        this.popups.removeIf(Popup::isClosing);
    }

    public void handleMouseRelease(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.leftMouseButtonPressed = false;
        }
    }

    public void handleMouseScroll(double mouseX, double mouseY, double delta) {
        int dWheel = (int)delta * 4;
        if (dWheel == 0) {
            return;
        }
        for (int i = this.windows.size() - 1; i >= 0; --i) {
            Window window = this.windows.get(i);
            if (!window.isScrollingEnabled() || window.isMinimized() || window.isInvisible() || mouseX < (double)window.getX() || mouseY < (double)(window.getY() + 13) || mouseX >= (double)(window.getX() + window.getWidth()) || mouseY >= (double)(window.getY() + window.getHeight())) continue;
            int scroll = window.getScrollOffset() + dWheel;
            scroll = Math.min(scroll, 0);
            scroll = Math.max(scroll, -window.getInnerHeight() + window.getHeight() - 13);
            window.setScrollOffset(scroll);
            break;
        }
    }

    public boolean handleNavigatorPopupClick(double mouseX, double mouseY, int mouseButton) {
        boolean popupClicked = this.handlePopupMouseClick(mouseX, mouseY, mouseButton);
        if (popupClicked) {
            for (Popup popup : this.popups) {
                if (!popup.getOwner().getParent().isClosing()) continue;
                popup.close();
            }
            this.popups.removeIf(Popup::isClosing);
        }
        return popupClicked;
    }

    public void handleNavigatorMouseClick(double cMouseX, double cMouseY, int mouseButton, Window window) {
        if (mouseButton == 0) {
            this.leftMouseButtonPressed = true;
        }
        this.handleComponentMouseClick(window, cMouseX, cMouseY, mouseButton);
        for (Popup popup : this.popups) {
            if (!popup.getOwner().getParent().isClosing()) continue;
            popup.close();
        }
        this.popups.removeIf(Popup::isClosing);
    }

    private boolean handlePopupMouseClick(double mouseX, double mouseY, int mouseButton) {
        for (int i = this.popups.size() - 1; i >= 0; --i) {
            Popup popup = this.popups.get(i);
            Component owner = popup.getOwner();
            Window parent = owner.getParent();
            int x0 = parent.getX() + owner.getX();
            int y0 = parent.getY() + 13 + parent.getScrollOffset() + owner.getY();
            int x1 = x0 + popup.getX();
            int y1 = y0 + popup.getY();
            int x2 = x1 + popup.getWidth();
            int y2 = y1 + popup.getHeight();
            if (mouseX < (double)x1 || mouseY < (double)y1 || mouseX >= (double)x2 || mouseY >= (double)y2) continue;
            int cMouseX = (int)(mouseX - (double)x0);
            int cMouseY = (int)(mouseY - (double)y0);
            popup.handleMouseClick(cMouseX, cMouseY, mouseButton);
            this.popups.remove(i);
            this.popups.add(popup);
            return true;
        }
        return false;
    }

    private void handleWindowMouseClick(int mouseX, int mouseY, int mouseButton) {
        for (int i = this.windows.size() - 1; i >= 0; --i) {
            Window window = this.windows.get(i);
            if (window.isInvisible()) continue;
            int x1 = window.getX();
            int y1 = window.getY();
            int x2 = x1 + window.getWidth();
            int y2 = y1 + window.getHeight();
            int y3 = y1 + 13;
            if (mouseX < x1 || mouseY < y1 || mouseX >= x2 || mouseY >= y2) continue;
            if (mouseY < y3) {
                this.handleTitleBarMouseClick(window, mouseX, mouseY, mouseButton);
            } else {
                if (window.isMinimized()) continue;
                window.validate();
                int cMouseX = mouseX - x1;
                int cMouseY = mouseY - y3;
                if (window.isScrollingEnabled() && mouseX >= x2 - 3) {
                    this.handleScrollbarMouseClick(window, cMouseX, cMouseY, mouseButton);
                } else {
                    if (window.isScrollingEnabled()) {
                        cMouseY -= window.getScrollOffset();
                    }
                    this.handleComponentMouseClick(window, cMouseX, cMouseY, mouseButton);
                }
            }
            this.windows.remove(i);
            this.windows.add(window);
            break;
        }
    }

    private void handleTitleBarMouseClick(Window window, int mouseX, int mouseY, int mouseButton) {
        if (mouseButton != 0) {
            return;
        }
        if (mouseY < window.getY() + 2 || mouseY >= window.getY() + 11) {
            window.startDragging(mouseX, mouseY);
            return;
        }
        int x3 = window.getX() + window.getWidth();
        if (window.isClosable() && mouseX >= (x3 -= 11) && mouseX < x3 + 9) {
            window.close();
            return;
        }
        if (window.isPinnable() && mouseX >= (x3 -= 11) && mouseX < x3 + 9) {
            window.setPinned(!window.isPinned());
            this.saveWindows();
            return;
        }
        if (window.isMinimizable() && mouseX >= (x3 -= 11) && mouseX < x3 + 9) {
            window.setMinimized(!window.isMinimized());
            this.saveWindows();
            return;
        }
        window.startDragging(mouseX, mouseY);
    }

    private void handleScrollbarMouseClick(Window window, int mouseX, int mouseY, int mouseButton) {
        if (mouseButton != 0) {
            return;
        }
        if (mouseX >= window.getWidth() - 1) {
            return;
        }
        double outerHeight = window.getHeight() - 13;
        double innerHeight = window.getInnerHeight();
        double maxScrollbarHeight = outerHeight - 2.0;
        int scrollbarY = (int)(outerHeight * ((double)(-window.getScrollOffset()) / innerHeight) + 1.0);
        int scrollbarHeight = (int)(maxScrollbarHeight * outerHeight / innerHeight);
        if (mouseY < scrollbarY || mouseY >= scrollbarY + scrollbarHeight) {
            return;
        }
        window.startDraggingScrollbar(window.getY() + 13 + mouseY);
    }

    private void handleComponentMouseClick(Window window, double mouseX, double mouseY, int mouseButton) {
        for (int i2 = window.countChildren() - 1; i2 >= 0; --i2) {
            Component c = window.getChild(i2);
            if (mouseX < (double)c.getX() || mouseY < (double)c.getY() || mouseX >= (double)(c.getX() + c.getWidth()) || mouseY >= (double)(c.getY() + c.getHeight())) continue;
            c.handleMouseClick(mouseX, mouseY, mouseButton);
            break;
        }
    }

    public void render(class_332 context, int mouseX, int mouseY, float partialTicks) {
        this.updateColors();
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderSystem.lineWidth((float)1.0f);
        class_4587 matrixStack = context.method_51448();
        matrixStack.method_22903();
        this.tooltip = "";
        for (Window window : this.windows) {
            if (window.isInvisible()) continue;
            if (window.isDragging()) {
                if (this.leftMouseButtonPressed) {
                    window.dragTo(mouseX, mouseY);
                } else {
                    window.stopDragging();
                    this.saveWindows();
                }
            }
            if (window.isDraggingScrollbar()) {
                if (this.leftMouseButtonPressed) {
                    window.dragScrollbarTo(mouseY);
                } else {
                    window.stopDraggingScrollbar();
                }
            }
            matrixStack.method_46416(0.0f, 0.0f, 300.0f);
            this.renderWindow(context, window, mouseX, mouseY, partialTicks);
        }
        this.renderPopups(context, mouseX, mouseY);
        this.renderTooltip(context, mouseX, mouseY);
        matrixStack.method_22909();
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
    }

    public void renderPopups(class_332 context, int mouseX, int mouseY) {
        class_4587 matrixStack = context.method_51448();
        for (Popup popup : this.popups) {
            Component owner = popup.getOwner();
            Window parent = owner.getParent();
            int x1 = parent.getX() + owner.getX();
            int y1 = parent.getY() + 13 + parent.getScrollOffset() + owner.getY();
            matrixStack.method_22903();
            matrixStack.method_46416((float)x1, (float)y1, 300.0f);
            int cMouseX = mouseX - x1;
            int cMouseY = mouseY - y1;
            popup.render(context, cMouseX, cMouseY);
            matrixStack.method_22909();
        }
    }

    public void renderTooltip(class_332 context, int mouseX, int mouseY) {
        class_4587 matrixStack = context.method_51448();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        if (this.tooltip.isEmpty()) {
            return;
        }
        String[] lines = this.tooltip.split("\n");
        class_327 fr = ClickGui.MC.field_1772;
        int tw = 0;
        int n = lines.length;
        Objects.requireNonNull(fr);
        int th = n * 9;
        for (String line : lines) {
            int lw = fr.method_1727(line);
            if (lw <= tw) continue;
            tw = lw;
        }
        int sw = ClickGui.MC.field_1755.field_22789;
        int sh = ClickGui.MC.field_1755.field_22790;
        int xt1 = mouseX + tw + 11 <= sw ? mouseX + 8 : mouseX - tw - 8;
        int xt2 = xt1 + tw + 3;
        int yt1 = mouseY + th - 2 <= sh ? mouseY - 4 : mouseY - th - 4;
        int yt2 = yt1 + th + 2;
        matrixStack.method_22903();
        matrixStack.method_46416(0.0f, 0.0f, 300.0f);
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        RenderSystem.setShader((class_10156)class_10142.field_53875);
        RenderUtils.setShaderColor(this.bgColor, this.ttOpacity);
        class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)xt1, (float)yt1, 0.0f);
        bufferBuilder.method_22918(matrix, (float)xt1, (float)yt2, 0.0f);
        bufferBuilder.method_22918(matrix, (float)xt2, (float)yt2, 0.0f);
        bufferBuilder.method_22918(matrix, (float)xt2, (float)yt1, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderUtils.setShaderColor(this.acColor, 0.5f);
        bufferBuilder = tessellator.method_60827(class_293.class_5596.field_29345, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)xt1, (float)yt1, 0.0f);
        bufferBuilder.method_22918(matrix, (float)xt1, (float)yt2, 0.0f);
        bufferBuilder.method_22918(matrix, (float)xt2, (float)yt2, 0.0f);
        bufferBuilder.method_22918(matrix, (float)xt2, (float)yt1, 0.0f);
        bufferBuilder.method_22918(matrix, (float)xt1, (float)yt1, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < lines.length; ++i) {
            String string = lines[i];
            Objects.requireNonNull(fr);
            context.method_51433(fr, string, xt1 + 2, yt1 + 2 + i * 9, this.txtColor, false);
        }
        GL11.glEnable((int)3042);
        matrixStack.method_22909();
    }

    public void renderPinnedWindows(class_332 context, float partialTicks) {
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderSystem.lineWidth((float)1.0f);
        class_4587 matrixStack = context.method_51448();
        matrixStack.method_22903();
        for (Window window : this.windows) {
            if (!window.isPinned() || window.isInvisible()) continue;
            matrixStack.method_46416(0.0f, 0.0f, 300.0f);
            this.renderWindow(context, window, Integer.MIN_VALUE, Integer.MIN_VALUE, partialTicks);
        }
        matrixStack.method_22909();
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
    }

    public void updateColors() {
        ClickGuiHack clickGui = ClickGui.WURST.getHax().clickGuiHack;
        this.opacity = clickGui.getOpacity();
        this.ttOpacity = clickGui.getTooltipOpacity();
        this.bgColor = clickGui.getBackgroundColor();
        this.txtColor = clickGui.getTextColor();
        this.maxHeight = clickGui.getMaxHeight();
        this.maxSettingsHeight = clickGui.getMaxSettingsHeight();
        this.acColor = WurstClient.INSTANCE.getHax().rainbowUiHack.isEnabled() ? RenderUtils.getRainbowColor() : clickGui.getAccentColor();
    }

    private void renderWindow(class_332 context, Window window, int mouseX, int mouseY, float partialTicks) {
        boolean hovering;
        int x4;
        boolean hoveringY;
        int x1 = window.getX();
        int y1 = window.getY();
        int x2 = x1 + window.getWidth();
        int y2 = y1 + window.getHeight();
        int y3 = y1 + 13;
        class_4587 matrixStack = context.method_51448();
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        RenderSystem.setShader((class_10156)class_10142.field_53875);
        if (window.isMinimized()) {
            y2 = y3;
        }
        if (mouseX >= x1 && mouseY >= y1 && mouseX < x2 && mouseY < y2) {
            this.tooltip = "";
        }
        if (!window.isMinimized()) {
            int yc1;
            window.setMaxHeight(window instanceof SettingsWindow ? this.maxSettingsHeight : this.maxHeight);
            window.validate();
            if (window.isScrollingEnabled()) {
                int xs1 = x2 - 3;
                int xs2 = xs1 + 2;
                int xs3 = x2;
                double outerHeight = y2 - y3;
                double innerHeight = window.getInnerHeight();
                double maxScrollbarHeight = outerHeight - 2.0;
                double scrollbarY = outerHeight * ((double)(-window.getScrollOffset()) / innerHeight) + 1.0;
                double scrollbarHeight = maxScrollbarHeight * outerHeight / innerHeight;
                int ys1 = y3;
                int ys2 = y2;
                int ys3 = ys1 + (int)scrollbarY;
                int ys4 = ys3 + (int)scrollbarHeight;
                RenderUtils.setShaderColor(this.bgColor, this.opacity);
                class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1592);
                bufferBuilder.method_22918(matrix, (float)xs2, (float)ys1, 0.0f);
                bufferBuilder.method_22918(matrix, (float)xs2, (float)ys2, 0.0f);
                bufferBuilder.method_22918(matrix, (float)xs3, (float)ys2, 0.0f);
                bufferBuilder.method_22918(matrix, (float)xs3, (float)ys1, 0.0f);
                bufferBuilder.method_22918(matrix, (float)xs1, (float)ys1, 0.0f);
                bufferBuilder.method_22918(matrix, (float)xs1, (float)ys3, 0.0f);
                bufferBuilder.method_22918(matrix, (float)xs2, (float)ys3, 0.0f);
                bufferBuilder.method_22918(matrix, (float)xs2, (float)ys1, 0.0f);
                bufferBuilder.method_22918(matrix, (float)xs1, (float)ys4, 0.0f);
                bufferBuilder.method_22918(matrix, (float)xs1, (float)ys2, 0.0f);
                bufferBuilder.method_22918(matrix, (float)xs2, (float)ys2, 0.0f);
                bufferBuilder.method_22918(matrix, (float)xs2, (float)ys4, 0.0f);
                class_286.method_43433((class_9801)bufferBuilder.method_60800());
                boolean hovering2 = mouseX >= xs1 && mouseY >= ys3 && mouseX < xs2 && mouseY < ys4;
                RenderUtils.setShaderColor(this.acColor, hovering2 ? this.opacity * 1.5f : this.opacity);
                bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1592);
                bufferBuilder.method_22918(matrix, (float)xs1, (float)ys3, 0.0f);
                bufferBuilder.method_22918(matrix, (float)xs1, (float)ys4, 0.0f);
                bufferBuilder.method_22918(matrix, (float)xs2, (float)ys4, 0.0f);
                bufferBuilder.method_22918(matrix, (float)xs2, (float)ys3, 0.0f);
                class_286.method_43433((class_9801)bufferBuilder.method_60800());
                RenderUtils.setShaderColor(this.acColor, 0.5f);
                bufferBuilder = tessellator.method_60827(class_293.class_5596.field_29345, class_290.field_1592);
                bufferBuilder.method_22918(matrix, (float)xs1, (float)ys3, 0.0f);
                bufferBuilder.method_22918(matrix, (float)xs1, (float)ys4, 0.0f);
                bufferBuilder.method_22918(matrix, (float)xs2, (float)ys4, 0.0f);
                bufferBuilder.method_22918(matrix, (float)xs2, (float)ys3, 0.0f);
                bufferBuilder.method_22918(matrix, (float)xs1, (float)ys3, 0.0f);
                class_286.method_43433((class_9801)bufferBuilder.method_60800());
            }
            int x3 = x1 + 2;
            int x42 = window.isScrollingEnabled() ? x2 - 3 : x2;
            int x5 = x42 - 2;
            int y4 = y3 + window.getScrollOffset();
            RenderUtils.setShaderColor(this.bgColor, this.opacity);
            class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1592);
            bufferBuilder.method_22918(matrix, (float)x1, (float)y3, 0.0f);
            bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f);
            bufferBuilder.method_22918(matrix, (float)x3, (float)y2, 0.0f);
            bufferBuilder.method_22918(matrix, (float)x3, (float)y3, 0.0f);
            bufferBuilder.method_22918(matrix, (float)x5, (float)y3, 0.0f);
            bufferBuilder.method_22918(matrix, (float)x5, (float)y2, 0.0f);
            bufferBuilder.method_22918(matrix, (float)x42, (float)y2, 0.0f);
            bufferBuilder.method_22918(matrix, (float)x42, (float)y3, 0.0f);
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
            RenderUtils.enableScissor(context, x1, y3, x2, y2);
            matrixStack.method_22903();
            matrixStack.method_46416((float)x1, (float)y4, 0.0f);
            matrix = matrixStack.method_23760().method_23761();
            RenderUtils.setShaderColor(this.bgColor, this.opacity);
            bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1592);
            int xc1 = 2;
            int xc2 = x5 - x1;
            for (int i = 0; i < window.countChildren(); ++i) {
                int yc12 = window.getChild(i).getY();
                int yc2 = yc12 - 2;
                bufferBuilder.method_22918(matrix, (float)xc1, (float)yc2, 0.0f);
                bufferBuilder.method_22918(matrix, (float)xc1, (float)yc12, 0.0f);
                bufferBuilder.method_22918(matrix, (float)xc2, (float)yc12, 0.0f);
                bufferBuilder.method_22918(matrix, (float)xc2, (float)yc2, 0.0f);
            }
            if (window.countChildren() == 0) {
                yc1 = 0;
            } else {
                Component lastChild = window.getChild(window.countChildren() - 1);
                yc1 = lastChild.getY() + lastChild.getHeight();
            }
            int yc2 = yc1 + 2;
            bufferBuilder.method_22918(matrix, (float)xc1, (float)yc2, 0.0f);
            bufferBuilder.method_22918(matrix, (float)xc1, (float)yc1, 0.0f);
            bufferBuilder.method_22918(matrix, (float)xc2, (float)yc1, 0.0f);
            bufferBuilder.method_22918(matrix, (float)xc2, (float)yc2, 0.0f);
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
            int cMouseX = mouseX - x1;
            int cMouseY = mouseY - y4;
            for (int i = 0; i < window.countChildren(); ++i) {
                window.getChild(i).render(context, cMouseX, cMouseY, partialTicks);
            }
            matrixStack.method_22909();
            matrix = matrixStack.method_23760().method_23761();
            RenderUtils.disableScissor(context);
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderUtils.setShaderColor(this.acColor, 0.5f);
        class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_29345, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        if (!window.isMinimized()) {
            bufferBuilder = tessellator.method_60827(class_293.class_5596.field_29344, class_290.field_1592);
            bufferBuilder.method_22918(matrix, (float)x1, (float)y3, 0.0f);
            bufferBuilder.method_22918(matrix, (float)x2, (float)y3, 0.0f);
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
        }
        int x3 = x2;
        int y4 = y1 + 2;
        int y5 = y3 - 2;
        boolean bl = hoveringY = mouseY >= y4 && mouseY < y5;
        if (window.isClosable()) {
            x4 = (x3 -= 11) + 9;
            hovering = hoveringY && mouseX >= x3 && mouseX < x4;
            this.renderCloseButton(matrixStack, x3, y4, x4, y5, hovering);
        }
        if (window.isPinnable()) {
            x4 = (x3 -= 11) + 9;
            hovering = hoveringY && mouseX >= x3 && mouseX < x4;
            this.renderPinButton(matrixStack, x3, y4, x4, y5, hovering, window.isPinned());
        }
        if (window.isMinimizable()) {
            x4 = (x3 -= 11) + 9;
            hovering = hoveringY && mouseX >= x3 && mouseX < x4;
            this.renderMinimizeButton(matrixStack, x3, y4, x4, y5, hovering, window.isMinimized());
        }
        RenderUtils.setShaderColor(this.acColor, this.opacity);
        bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)x3, (float)y1, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x3, (float)y4, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y4, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x3, (float)y5, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x3, (float)y3, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y3, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y5, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y3, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x3, (float)y3, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x3, (float)y1, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_327 fr = ClickGui.MC.field_1772;
        String title = fr.method_1714((class_5348)class_2561.method_43470((String)window.getTitle()), x3 - x1).getString();
        context.method_51433(fr, title, x1 + 2, y1 + 3, this.txtColor, false);
        GL11.glEnable((int)3042);
    }

    private void renderTitleBarButton(class_4587 matrixStack, int x1, int y1, int x2, int y2, boolean hovering) {
        int x3 = x2 + 2;
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        RenderSystem.setShader((class_10156)class_10142.field_53875);
        RenderUtils.setShaderColor(this.bgColor, hovering ? this.opacity * 1.5f : this.opacity);
        class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderUtils.setShaderColor(this.acColor, this.opacity);
        bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x3, (float)y2, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x3, (float)y1, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderUtils.setShaderColor(this.acColor, 0.5f);
        bufferBuilder = tessellator.method_60827(class_293.class_5596.field_29345, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
    }

    private void renderMinimizeButton(class_4587 matrixStack, int x1, int y1, int x2, int y2, boolean hovering, boolean minimized) {
        float ya2;
        float ya1;
        this.renderTitleBarButton(matrixStack, x1, y1, x2, y2, hovering);
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        float xa1 = x1 + 1;
        float xa2 = (float)(x1 + x2) / 2.0f;
        float xa3 = x2 - 1;
        if (minimized) {
            ya1 = y1 + 3;
            ya2 = (float)y2 - 2.5f;
            RenderSystem.setShaderColor((float)0.0f, (float)(hovering ? 1.0f : 0.85f), (float)0.0f, (float)1.0f);
        } else {
            ya1 = y2 - 3;
            ya2 = (float)y1 + 2.5f;
            RenderSystem.setShaderColor((float)(hovering ? 1.0f : 0.85f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27379, class_290.field_1592);
        bufferBuilder.method_22918(matrix, xa1, ya1, 0.0f);
        bufferBuilder.method_22918(matrix, xa3, ya1, 0.0f);
        bufferBuilder.method_22918(matrix, xa2, ya2, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.setShaderColor((float)0.0625f, (float)0.0625f, (float)0.0625f, (float)0.5f);
        bufferBuilder = tessellator.method_60827(class_293.class_5596.field_29345, class_290.field_1592);
        bufferBuilder.method_22918(matrix, xa1, ya1, 0.0f);
        bufferBuilder.method_22918(matrix, xa3, ya1, 0.0f);
        bufferBuilder.method_22918(matrix, xa2, ya2, 0.0f);
        bufferBuilder.method_22918(matrix, xa1, ya1, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
    }

    private void renderPinButton(class_4587 matrixStack, int x1, int y1, int x2, int y2, boolean hovering, boolean pinned) {
        this.renderTitleBarButton(matrixStack, x1, y1, x2, y2, hovering);
        float h = hovering ? 1.0f : 0.85f;
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        if (pinned) {
            float xk1 = x1 + 2;
            float xk2 = x2 - 2;
            float xk3 = x1 + 1;
            float xk4 = x2 - 1;
            float yk1 = y1 + 2;
            float yk2 = y2 - 2;
            float yk3 = (float)y2 - 0.5f;
            RenderSystem.setShaderColor((float)h, (float)0.0f, (float)0.0f, (float)0.5f);
            class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1592);
            bufferBuilder.method_22918(matrix, xk1, yk1, 0.0f);
            bufferBuilder.method_22918(matrix, xk2, yk1, 0.0f);
            bufferBuilder.method_22918(matrix, xk2, yk2, 0.0f);
            bufferBuilder.method_22918(matrix, xk1, yk2, 0.0f);
            bufferBuilder.method_22918(matrix, xk3, yk2, 0.0f);
            bufferBuilder.method_22918(matrix, xk4, yk2, 0.0f);
            bufferBuilder.method_22918(matrix, xk4, yk3, 0.0f);
            bufferBuilder.method_22918(matrix, xk3, yk3, 0.0f);
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
            float xn1 = (float)x1 + 3.5f;
            float xn2 = (float)x2 - 3.5f;
            float yn1 = (float)y2 - 0.5f;
            float yn2 = y2;
            RenderSystem.setShaderColor((float)h, (float)h, (float)h, (float)1.0f);
            bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1592);
            bufferBuilder.method_22918(matrix, xn1, yn1, 0.0f);
            bufferBuilder.method_22918(matrix, xn2, yn1, 0.0f);
            bufferBuilder.method_22918(matrix, xn2, yn2, 0.0f);
            bufferBuilder.method_22918(matrix, xn1, yn2, 0.0f);
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
            RenderSystem.setShaderColor((float)0.0625f, (float)0.0625f, (float)0.0625f, (float)0.5f);
            bufferBuilder = tessellator.method_60827(class_293.class_5596.field_29345, class_290.field_1592);
            bufferBuilder.method_22918(matrix, xk1, yk1, 0.0f);
            bufferBuilder.method_22918(matrix, xk2, yk1, 0.0f);
            bufferBuilder.method_22918(matrix, xk2, yk2, 0.0f);
            bufferBuilder.method_22918(matrix, xk1, yk2, 0.0f);
            bufferBuilder.method_22918(matrix, xk1, yk1, 0.0f);
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
            bufferBuilder = tessellator.method_60827(class_293.class_5596.field_29345, class_290.field_1592);
            bufferBuilder.method_22918(matrix, xk3, yk2, 0.0f);
            bufferBuilder.method_22918(matrix, xk4, yk2, 0.0f);
            bufferBuilder.method_22918(matrix, xk4, yk3, 0.0f);
            bufferBuilder.method_22918(matrix, xk3, yk3, 0.0f);
            bufferBuilder.method_22918(matrix, xk3, yk2, 0.0f);
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
            bufferBuilder = tessellator.method_60827(class_293.class_5596.field_29345, class_290.field_1592);
            bufferBuilder.method_22918(matrix, xn1, yn1, 0.0f);
            bufferBuilder.method_22918(matrix, xn2, yn1, 0.0f);
            bufferBuilder.method_22918(matrix, xn2, yn2, 0.0f);
            bufferBuilder.method_22918(matrix, xn1, yn2, 0.0f);
            bufferBuilder.method_22918(matrix, xn1, yn1, 0.0f);
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
        } else {
            float xk1 = (float)x2 - 3.5f;
            float xk2 = (float)x2 - 0.5f;
            float xk3 = x2 - 3;
            float xk4 = x1 + 3;
            float xk5 = x1 + 2;
            float xk6 = x2 - 2;
            float xk7 = x1 + 1;
            float yk1 = (float)y1 + 0.5f;
            float yk2 = (float)y1 + 3.5f;
            float yk3 = y2 - 3;
            float yk4 = y1 + 3;
            float yk5 = y1 + 2;
            float yk6 = y2 - 2;
            float yk7 = y2 - 1;
            RenderSystem.setShaderColor((float)0.0f, (float)h, (float)0.0f, (float)1.0f);
            class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1592);
            bufferBuilder.method_22918(matrix, xk1, yk1, 0.0f);
            bufferBuilder.method_22918(matrix, xk2, yk2, 0.0f);
            bufferBuilder.method_22918(matrix, xk3, yk3, 0.0f);
            bufferBuilder.method_22918(matrix, xk4, yk4, 0.0f);
            bufferBuilder.method_22918(matrix, xk5, yk5, 0.0f);
            bufferBuilder.method_22918(matrix, xk6, yk6, 0.0f);
            bufferBuilder.method_22918(matrix, xk3, yk7, 0.0f);
            bufferBuilder.method_22918(matrix, xk7, yk4, 0.0f);
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
            float xn1 = x1 + 3;
            float xn2 = x1 + 4;
            float xn3 = x1 + 1;
            float yn1 = y2 - 4;
            float yn2 = y2 - 3;
            float yn3 = y2 - 1;
            RenderSystem.setShaderColor((float)h, (float)h, (float)h, (float)1.0f);
            bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27379, class_290.field_1592);
            bufferBuilder.method_22918(matrix, xn1, yn1, 0.0f);
            bufferBuilder.method_22918(matrix, xn2, yn2, 0.0f);
            bufferBuilder.method_22918(matrix, xn3, yn3, 0.0f);
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
            RenderSystem.setShaderColor((float)0.0625f, (float)0.0625f, (float)0.0625f, (float)0.5f);
            bufferBuilder = tessellator.method_60827(class_293.class_5596.field_29345, class_290.field_1592);
            bufferBuilder.method_22918(matrix, xk1, yk1, 0.0f);
            bufferBuilder.method_22918(matrix, xk2, yk2, 0.0f);
            bufferBuilder.method_22918(matrix, xk3, yk3, 0.0f);
            bufferBuilder.method_22918(matrix, xk4, yk4, 0.0f);
            bufferBuilder.method_22918(matrix, xk1, yk1, 0.0f);
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
            bufferBuilder = tessellator.method_60827(class_293.class_5596.field_29345, class_290.field_1592);
            bufferBuilder.method_22918(matrix, xk5, yk5, 0.0f);
            bufferBuilder.method_22918(matrix, xk6, yk6, 0.0f);
            bufferBuilder.method_22918(matrix, xk3, yk7, 0.0f);
            bufferBuilder.method_22918(matrix, xk7, yk4, 0.0f);
            bufferBuilder.method_22918(matrix, xk5, yk5, 0.0f);
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
            bufferBuilder = tessellator.method_60827(class_293.class_5596.field_29345, class_290.field_1592);
            bufferBuilder.method_22918(matrix, xn1, yn1, 0.0f);
            bufferBuilder.method_22918(matrix, xn2, yn2, 0.0f);
            bufferBuilder.method_22918(matrix, xn3, yn3, 0.0f);
            bufferBuilder.method_22918(matrix, xn1, yn1, 0.0f);
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
        }
    }

    private void renderCloseButton(class_4587 matrixStack, int x1, int y1, int x2, int y2, boolean hovering) {
        this.renderTitleBarButton(matrixStack, x1, y1, x2, y2, hovering);
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        float xc1 = x1 + 2;
        float xc2 = x1 + 3;
        float xc3 = x2 - 2;
        float xc4 = x2 - 3;
        float xc5 = (float)x1 + 3.5f;
        float xc6 = (float)(x1 + x2) / 2.0f;
        float xc7 = (float)x2 - 3.5f;
        float yc1 = y1 + 3;
        float yc2 = y1 + 2;
        float yc3 = y2 - 3;
        float yc4 = y2 - 2;
        float yc5 = (float)y1 + 3.5f;
        float yc6 = (float)(y1 + y2) / 2.0f;
        float yc7 = (float)y2 - 3.5f;
        RenderSystem.setShaderColor((float)(hovering ? 1.0f : 0.85f), (float)0.0f, (float)0.0f, (float)1.0f);
        class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22918(matrix, xc1, yc1, 0.0f);
        bufferBuilder.method_22918(matrix, xc2, yc2, 0.0f);
        bufferBuilder.method_22918(matrix, xc3, yc3, 0.0f);
        bufferBuilder.method_22918(matrix, xc4, yc4, 0.0f);
        bufferBuilder.method_22918(matrix, xc3, yc1, 0.0f);
        bufferBuilder.method_22918(matrix, xc4, yc2, 0.0f);
        bufferBuilder.method_22918(matrix, xc6, yc5, 0.0f);
        bufferBuilder.method_22918(matrix, xc7, yc6, 0.0f);
        bufferBuilder.method_22918(matrix, xc6, yc7, 0.0f);
        bufferBuilder.method_22918(matrix, xc5, yc6, 0.0f);
        bufferBuilder.method_22918(matrix, xc1, yc3, 0.0f);
        bufferBuilder.method_22918(matrix, xc2, yc4, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.setShaderColor((float)0.0625f, (float)0.0625f, (float)0.0625f, (float)0.5f);
        bufferBuilder = tessellator.method_60827(class_293.class_5596.field_29344, class_290.field_1592);
        bufferBuilder.method_22918(matrix, xc1, yc1, 0.0f);
        bufferBuilder.method_22918(matrix, xc2, yc2, 0.0f);
        bufferBuilder.method_22918(matrix, xc6, yc5, 0.0f);
        bufferBuilder.method_22918(matrix, xc4, yc2, 0.0f);
        bufferBuilder.method_22918(matrix, xc3, yc1, 0.0f);
        bufferBuilder.method_22918(matrix, xc7, yc6, 0.0f);
        bufferBuilder.method_22918(matrix, xc3, yc3, 0.0f);
        bufferBuilder.method_22918(matrix, xc4, yc4, 0.0f);
        bufferBuilder.method_22918(matrix, xc6, yc7, 0.0f);
        bufferBuilder.method_22918(matrix, xc2, yc4, 0.0f);
        bufferBuilder.method_22918(matrix, xc1, yc3, 0.0f);
        bufferBuilder.method_22918(matrix, xc5, yc6, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
    }

    public float[] getBgColor() {
        return this.bgColor;
    }

    public float[] getAcColor() {
        return this.acColor;
    }

    public int getTxtColor() {
        return this.txtColor;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = Objects.requireNonNull(tooltip);
    }

    public void addWindow(Window window) {
        this.windows.add(window);
    }

    public void addPopup(Popup popup) {
        this.popups.add(popup);
    }

    public boolean isLeftMouseButtonPressed() {
        return this.leftMouseButtonPressed;
    }
}

