/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.clickgui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_9801;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.ClickGui;
import net.wurstclient.clickgui.Component;
import net.wurstclient.clickgui.Popup;
import net.wurstclient.settings.EnumSetting;
import net.wurstclient.util.RenderUtils;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public final class ComboBoxPopup<T extends Enum<T>>
extends Popup {
    private final ClickGui gui = WurstClient.INSTANCE.getGui();
    private final class_327 tr;
    private final EnumSetting<T> setting;
    private final int popupWidth;

    public ComboBoxPopup(Component owner, EnumSetting<T> setting, int popupWidth) {
        super(owner);
        this.tr = WurstClient.MC.field_1772;
        this.setting = setting;
        this.popupWidth = popupWidth;
        this.setWidth(this.getDefaultWidth());
        this.setHeight(this.getDefaultHeight());
        this.setX(owner.getWidth() - this.getWidth());
        this.setY(owner.getHeight());
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton != 0) {
            return;
        }
        int yi1 = this.getY() - 11;
        for (Enum value : this.setting.getValues()) {
            if (value == this.setting.getSelected()) continue;
            int yi2 = (yi1 += 11) + 11;
            if (mouseY < yi1 || mouseY >= yi2) continue;
            this.setting.setSelected(value);
            this.close();
            break;
        }
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY) {
        int y2;
        int y1;
        int x2;
        class_4587 matrixStack = context.method_51448();
        int x1 = this.getX();
        boolean hovering = this.isHovering(mouseX, mouseY, x1, x2 = x1 + this.getWidth(), y1 = this.getY(), y2 = y1 + this.getHeight());
        if (hovering) {
            this.gui.setTooltip("");
        }
        this.drawOutline(matrixStack, x1, x2, y1, y2);
        int yi1 = y1 - 11;
        for (Enum value : this.setting.getValues()) {
            if (value == this.setting.getSelected()) continue;
            RenderSystem.setShader((class_10156)class_10142.field_53875);
            int yi2 = (yi1 += 11) + 11;
            boolean hValue = hovering && mouseY >= yi1 && mouseY < yi2;
            this.drawValueBackground(matrixStack, x1, x2, yi1, yi2, hValue);
            this.drawValueName(context, x1, yi1, value);
        }
    }

    private boolean isHovering(int mouseX, int mouseY, int x1, int x2, int y1, int y2) {
        return mouseX >= x1 && mouseY >= y1 && mouseX < x2 && mouseY < y2;
    }

    private void drawOutline(class_4587 matrixStack, int x1, int x2, int y1, int y2) {
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        float[] acColor = this.gui.getAcColor();
        RenderUtils.setShaderColor(acColor, 0.5f);
        class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_29345, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
    }

    private void drawValueBackground(class_4587 matrixStack, int x1, int x2, int yi1, int yi2, boolean hValue) {
        float[] bgColor = this.gui.getBgColor();
        float alpha = this.gui.getOpacity() * (hValue ? 1.5f : 1.0f);
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        RenderUtils.setShaderColor(bgColor, alpha);
        class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)x1, (float)yi1, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x1, (float)yi2, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x2, (float)yi2, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x2, (float)yi1, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
    }

    private void drawValueName(class_332 context, int x1, int yi1, Enum<?> value) {
        ClickGui gui = WurstClient.INSTANCE.getGui();
        int txtColor = gui.getTxtColor();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.method_51433(this.tr, value.toString(), x1 + 2, yi1 + 2, txtColor, false);
        GL11.glEnable((int)3042);
    }

    @Override
    public int getDefaultWidth() {
        return this.popupWidth + 15;
    }

    @Override
    public int getDefaultHeight() {
        int numValues = this.setting.getValues().length;
        return (numValues - 1) * 11;
    }
}

