/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.clickgui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_9801;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.ClickGui;
import net.wurstclient.clickgui.Component;
import net.wurstclient.clickgui.Window;
import net.wurstclient.clickgui.screens.EditColorScreen;
import net.wurstclient.settings.ColorSetting;
import net.wurstclient.util.ColorUtils;
import net.wurstclient.util.RenderUtils;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public final class ColorComponent
extends Component {
    private final class_310 MC = WurstClient.MC;
    private final ClickGui GUI = WurstClient.INSTANCE.getGui();
    private final ColorSetting setting;

    public ColorComponent(ColorSetting setting) {
        this.setting = setting;
        this.setWidth(this.getDefaultWidth());
        this.setHeight(this.getDefaultHeight());
    }

    @Override
    public void handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        if (mouseY < (double)(this.getY() + 11)) {
            return;
        }
        if (mouseButton == 0) {
            this.MC.method_1507((class_437)new EditColorScreen(this.MC.field_1755, this.setting));
        } else if (mouseButton == 1) {
            this.setting.setColor(this.setting.getDefaultColor());
        }
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float partialTicks) {
        class_4587 matrixStack = context.method_51448();
        int x1 = this.getX();
        int x2 = x1 + this.getWidth();
        int y1 = this.getY();
        int y2 = y1 + this.getHeight();
        int y3 = y1 + 11;
        boolean hovering = this.isHovering(mouseX, mouseY, x1, x2, y1, y2);
        RenderSystem.setShader((class_10156)class_10142.field_53875);
        if (hovering) {
            if (mouseY < y3) {
                this.GUI.setTooltip(this.setting.getWrappedDescription(200));
            } else {
                String tooltip = "\u00a7cR:\u00a7r" + this.setting.getRed();
                tooltip = tooltip + " \u00a7aG:\u00a7r" + this.setting.getGreen();
                tooltip = tooltip + " \u00a79B:\u00a7r" + this.setting.getBlue();
                tooltip = tooltip + "\n\n\u00a7e[left-click]\u00a7r to edit";
                tooltip = tooltip + "\n\u00a7e[right-click]\u00a7r to reset";
                this.GUI.setTooltip(tooltip);
            }
        }
        this.drawBackground(matrixStack, x1, x2, y1, y3);
        this.drawBox(matrixStack, x1, x2, y2, y3, hovering && mouseY >= y3);
        this.drawNameAndValue(context, x1, x2, y1 + 2);
    }

    private boolean isHovering(int mouseX, int mouseY, int x1, int x2, int y1, int y2) {
        Window parent = this.getParent();
        boolean scrollEnabled = parent.isScrollingEnabled();
        int scroll = scrollEnabled ? parent.getScrollOffset() : 0;
        return mouseX >= x1 && mouseY >= y1 && mouseX < x2 && mouseY < y2 && mouseY >= -scroll && mouseY < parent.getHeight() - 13 - scroll;
    }

    private void drawBackground(class_4587 matrixStack, int x1, int x2, int y1, int y2) {
        float[] bgColor = this.GUI.getBgColor();
        float opacity = this.GUI.getOpacity();
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        RenderUtils.setShaderColor(bgColor, opacity);
        class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
    }

    private void drawBox(class_4587 matrixStack, int x1, int x2, int y2, int y3, boolean hovering) {
        float[] color = this.setting.getColorF();
        float[] acColor = this.GUI.getAcColor();
        float opacity = this.GUI.getOpacity();
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        RenderUtils.setShaderColor(color, hovering ? 1.0f : opacity);
        class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y3, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y3, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderUtils.setShaderColor(acColor, 0.5f);
        bufferBuilder = tessellator.method_60827(class_293.class_5596.field_29345, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y3, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y3, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
    }

    private void drawNameAndValue(class_332 context, int x1, int x2, int y1) {
        ClickGui gui = WurstClient.INSTANCE.getGui();
        int txtColor = gui.getTxtColor();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_327 tr = this.MC.field_1772;
        context.method_51433(tr, this.setting.getName(), x1, y1, txtColor, false);
        String value = ColorUtils.toHex(this.setting.getColor());
        int valueWidth = tr.method_1727(value);
        context.method_51433(tr, value, x2 - valueWidth, y1, txtColor, false);
        GL11.glEnable((int)3042);
    }

    @Override
    public int getDefaultWidth() {
        return this.MC.field_1772.method_1727(this.setting.getName() + "#FFFFFF") + 6;
    }

    @Override
    public int getDefaultHeight() {
        return 22;
    }
}

