/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.clickgui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_9801;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.ClickGui;
import net.wurstclient.clickgui.Component;
import net.wurstclient.clickgui.Window;
import net.wurstclient.clickgui.screens.EditSliderScreen;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.util.RenderUtils;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public final class SliderComponent
extends Component {
    private final class_310 MC = WurstClient.MC;
    private final ClickGui GUI = WurstClient.INSTANCE.getGui();
    private final SliderSetting setting;
    private boolean dragging;

    public SliderComponent(SliderSetting setting) {
        this.setting = setting;
        this.setWidth(this.getDefaultWidth());
        this.setHeight(this.getDefaultHeight());
    }

    @Override
    public void handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        if (mouseY < (double)(this.getY() + 11)) {
            return;
        }
        switch (mouseButton) {
            case 0: {
                this.handleLeftClick();
                break;
            }
            case 1: {
                this.handleRightClick();
            }
        }
    }

    private void handleLeftClick() {
        if (class_437.method_25441()) {
            this.MC.method_1507((class_437)new EditSliderScreen(this.MC.field_1755, this.setting));
        } else {
            this.dragging = true;
        }
    }

    private void handleRightClick() {
        this.setting.setValue(this.setting.getDefaultValue());
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float partialTicks) {
        class_4587 matrixStack = context.method_51448();
        int x1 = this.getX();
        int x2 = x1 + this.getWidth();
        int x3 = x1 + 2;
        int x4 = x2 - 2;
        int y1 = this.getY();
        int y2 = y1 + this.getHeight();
        int y3 = y1 + 11;
        int y4 = y3 + 4;
        int y5 = y2 - 4;
        this.handleDragging(mouseX, x3, x4);
        boolean hovering = this.isHovering(mouseX, mouseY, x1, x2, y1, y2);
        boolean hSlider = hovering && mouseY >= y3 || this.dragging;
        boolean renderAsDisabled = this.setting.isDisabled() || this.setting.isLocked();
        RenderSystem.setShader((class_10156)class_10142.field_53875);
        if (hovering && mouseY < y3) {
            this.setTooltip();
        } else if (hSlider && !this.dragging) {
            this.GUI.setTooltip("\u00a7e[ctrl]\u00a7r+\u00a7e[left-click]\u00a7r for precise input\n\u00a7e[right-click]\u00a7r to reset");
        }
        if (renderAsDisabled) {
            hovering = false;
            hSlider = false;
        }
        this.drawBackground(matrixStack, x1, x2, x3, x4, y1, y2, y4, y5);
        this.drawRail(matrixStack, x3, x4, y4, y5, hSlider, renderAsDisabled);
        this.drawKnob(matrixStack, x1, x2, y2, y3, hSlider, renderAsDisabled);
        this.drawNameAndValue(context, x1, x2, y1, renderAsDisabled);
    }

    private void handleDragging(int mouseX, int x3, int x4) {
        if (!this.dragging) {
            return;
        }
        if (!this.GUI.isLeftMouseButtonPressed()) {
            this.dragging = false;
            return;
        }
        double sliderStartX = x3;
        double sliderWidth = x4 - x3;
        double mousePercentage = ((double)mouseX - sliderStartX) / sliderWidth;
        double min = this.setting.getMinimum();
        double range = this.setting.getRange();
        double value = min + range * mousePercentage;
        this.setting.setValue(value);
    }

    private boolean isHovering(int mouseX, int mouseY, int x1, int x2, int y1, int y2) {
        Window parent = this.getParent();
        boolean scrollEnabled = parent.isScrollingEnabled();
        int scroll = scrollEnabled ? parent.getScrollOffset() : 0;
        return mouseX >= x1 && mouseY >= y1 && mouseX < x2 && mouseY < y2 && mouseY >= -scroll && mouseY < parent.getHeight() - 13 - scroll;
    }

    private void setTooltip() {
        Object tooltip = this.setting.getWrappedDescription(200);
        if (this.setting.isLocked()) {
            tooltip = (String)tooltip + "\n\nThis slider is locked to ";
            tooltip = (String)tooltip + this.setting.getValueString() + ".";
        } else if (this.setting.isDisabled()) {
            tooltip = (String)tooltip + "\n\nThis slider is disabled.";
        }
        this.GUI.setTooltip((String)tooltip);
    }

    private void drawBackground(class_4587 matrixStack, int x1, int x2, int x3, int x4, int y1, int y2, int y4, int y5) {
        float[] bgColor = this.GUI.getBgColor();
        float opacity = this.GUI.getOpacity();
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        RenderUtils.setShaderColor(bgColor, opacity);
        class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y4, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y4, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y5, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y5, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y4, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y5, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x3, (float)y5, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x3, (float)y4, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x4, (float)y4, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x4, (float)y5, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y5, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y4, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
    }

    private void drawRail(class_4587 matrixStack, int x3, int x4, int y4, int y5, boolean hSlider, boolean renderAsDisabled) {
        float[] bgColor = this.GUI.getBgColor();
        float[] acColor = this.GUI.getAcColor();
        float opacity = this.GUI.getOpacity();
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        float xl1 = x3;
        float xl2 = x4;
        if (!renderAsDisabled && this.setting.isLimited()) {
            double ratio = (double)(x4 - x3) / this.setting.getRange();
            xl1 = (float)((double)xl1 + ratio * (this.setting.getUsableMin() - this.setting.getMinimum()));
            xl2 = (float)((double)xl2 + ratio * (this.setting.getUsableMax() - this.setting.getMaximum()));
        }
        RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)(hSlider ? opacity * 1.5f : opacity));
        class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)x3, (float)y4, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x3, (float)y5, 0.0f);
        bufferBuilder.method_22918(matrix, xl1, (float)y5, 0.0f);
        bufferBuilder.method_22918(matrix, xl1, (float)y4, 0.0f);
        bufferBuilder.method_22918(matrix, xl2, (float)y4, 0.0f);
        bufferBuilder.method_22918(matrix, xl2, (float)y5, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x4, (float)y5, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x4, (float)y4, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderUtils.setShaderColor(bgColor, hSlider ? opacity * 1.5f : opacity);
        bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22918(matrix, xl1, (float)y4, 0.0f);
        bufferBuilder.method_22918(matrix, xl1, (float)y5, 0.0f);
        bufferBuilder.method_22918(matrix, xl2, (float)y5, 0.0f);
        bufferBuilder.method_22918(matrix, xl2, (float)y4, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderUtils.setShaderColor(acColor, 0.5f);
        bufferBuilder = tessellator.method_60827(class_293.class_5596.field_29345, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)x3, (float)y4, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x3, (float)y5, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x4, (float)y5, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x4, (float)y4, 0.0f);
        bufferBuilder.method_22918(matrix, (float)x3, (float)y4, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
    }

    private void drawKnob(class_4587 matrixStack, int x1, int x2, int y2, int y3, boolean hSlider, boolean renderAsDisabled) {
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        double percentage = this.setting.getPercentage();
        float xk1 = (float)x1 + (float)(x2 - x1 - 8) * (float)percentage;
        float xk2 = xk1 + 8.0f;
        float yk1 = (float)y3 + 1.5f;
        float yk2 = (float)y2 - 1.5f;
        if (renderAsDisabled) {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.75f);
        } else {
            RenderUtils.setShaderColor(this.setting.getKnobColor(), hSlider ? 1.0f : 0.75f);
        }
        class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22918(matrix, xk1, yk1, 0.0f);
        bufferBuilder.method_22918(matrix, xk1, yk2, 0.0f);
        bufferBuilder.method_22918(matrix, xk2, yk2, 0.0f);
        bufferBuilder.method_22918(matrix, xk2, yk1, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.setShaderColor((float)0.0625f, (float)0.0625f, (float)0.0625f, (float)0.5f);
        bufferBuilder = tessellator.method_60827(class_293.class_5596.field_29345, class_290.field_1592);
        bufferBuilder.method_22918(matrix, xk1, yk1, 0.0f);
        bufferBuilder.method_22918(matrix, xk1, yk2, 0.0f);
        bufferBuilder.method_22918(matrix, xk2, yk2, 0.0f);
        bufferBuilder.method_22918(matrix, xk2, yk1, 0.0f);
        bufferBuilder.method_22918(matrix, xk1, yk1, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
    }

    private void drawNameAndValue(class_332 context, int x1, int x2, int y1, boolean renderAsDisabled) {
        ClickGui gui = WurstClient.INSTANCE.getGui();
        int txtColor = gui.getTxtColor();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_327 tr = this.MC.field_1772;
        String name = this.setting.getName();
        String value = this.setting.getValueString();
        int valueWidth = tr.method_1727(value);
        context.method_51433(tr, name, x1, y1 + 2, txtColor, false);
        context.method_51433(tr, value, x2 - valueWidth, y1 + 2, txtColor, false);
        GL11.glEnable((int)3042);
    }

    @Override
    public int getDefaultWidth() {
        class_327 tr = this.MC.field_1772;
        int nameWitdh = tr.method_1727(this.setting.getName());
        int valueWidth = tr.method_1727(this.setting.getValueString());
        return nameWitdh + valueWidth + 6;
    }

    @Override
    public int getDefaultHeight() {
        return 22;
    }
}

