/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.commands;

import java.util.List;
import net.minecraft.class_2248;
import net.wurstclient.DontBlock;
import net.wurstclient.Feature;
import net.wurstclient.command.CmdError;
import net.wurstclient.command.CmdException;
import net.wurstclient.command.CmdSyntaxError;
import net.wurstclient.command.Command;
import net.wurstclient.settings.BlockListSetting;
import net.wurstclient.settings.Setting;
import net.wurstclient.util.BlockUtils;
import net.wurstclient.util.ChatUtils;
import net.wurstclient.util.CmdUtils;
import net.wurstclient.util.MathUtils;

@DontBlock
public final class BlockListCmd
extends Command {
    public BlockListCmd() {
        super("blocklist", "Changes a BlockList setting of a feature. Allows you\nto change these settings through keybinds.", ".blocklist <feature> <setting> add <block>", ".blocklist <feature> <setting> remove <block>", ".blocklist <feature> <setting> list [<page>]", ".blocklist <feature> <setting> reset", "Example: .blocklist Nuker MultiID_List add gravel");
    }

    @Override
    public void call(String[] args) throws CmdException {
        if (args.length < 3 || args.length > 4) {
            throw new CmdSyntaxError();
        }
        Feature feature = CmdUtils.findFeature(args[0]);
        Setting abstractSetting = CmdUtils.findSetting(feature, args[1]);
        BlockListSetting setting = this.getAsBlockListSetting(feature, abstractSetting);
        switch (args[2].toLowerCase()) {
            case "add": {
                this.add(feature, setting, args);
                break;
            }
            case "remove": {
                this.remove(feature, setting, args);
                break;
            }
            case "list": {
                this.list(feature, setting, args);
                break;
            }
            case "reset": {
                setting.resetToDefaults();
                break;
            }
            default: {
                throw new CmdSyntaxError();
            }
        }
    }

    private void add(Feature feature, BlockListSetting setting, String[] args) throws CmdException {
        if (args.length != 4) {
            throw new CmdSyntaxError();
        }
        String inputBlockName = args[3];
        class_2248 block = BlockUtils.getBlockFromNameOrID(inputBlockName);
        if (block == null) {
            throw new CmdSyntaxError("\"" + inputBlockName + "\" is not a valid block.");
        }
        String blockName = BlockUtils.getName(block);
        if (setting.contains(blockName)) {
            throw new CmdError(feature.getName() + " " + setting.getName() + " already contains " + blockName);
        }
        setting.add(block);
    }

    private void remove(Feature feature, BlockListSetting setting, String[] args) throws CmdException {
        if (args.length != 4) {
            throw new CmdSyntaxError();
        }
        String inputBlockName = args[3];
        class_2248 block = BlockUtils.getBlockFromNameOrID(inputBlockName);
        if (block == null) {
            throw new CmdSyntaxError("\"" + inputBlockName + "\" is not a valid block.");
        }
        String blockName = BlockUtils.getName(block);
        int index = setting.indexOf(blockName);
        if (index < 0) {
            throw new CmdError(feature.getName() + " " + setting.getName() + " does not contain " + blockName);
        }
        setting.remove(index);
    }

    private void list(Feature feature, BlockListSetting setting, String[] args) throws CmdException {
        if (args.length > 4) {
            throw new CmdSyntaxError();
        }
        List<String> blocks = setting.getBlockNames();
        int page = this.parsePage(args);
        int pages = (int)Math.ceil((double)blocks.size() / 8.0);
        if (page > (pages = Math.max(pages, 1)) || page < 1) {
            throw new CmdSyntaxError("Invalid page: " + page);
        }
        String total = "Total: " + blocks.size() + " block";
        total = total + (blocks.size() != 1 ? "s" : "");
        ChatUtils.message(total);
        int start = (page - 1) * 8;
        int end = Math.min(page * 8, blocks.size());
        ChatUtils.message(feature.getName() + " " + setting.getName() + " (page " + page + "/" + pages + ")");
        for (int i = start; i < end; ++i) {
            ChatUtils.message(blocks.get(i).toString());
        }
    }

    private int parsePage(String[] args) throws CmdSyntaxError {
        if (args.length < 4) {
            return 1;
        }
        if (!MathUtils.isInteger(args[3])) {
            throw new CmdSyntaxError("Not a number: " + args[3]);
        }
        return Integer.parseInt(args[3]);
    }

    private BlockListSetting getAsBlockListSetting(Feature feature, Setting setting) throws CmdError {
        if (!(setting instanceof BlockListSetting)) {
            throw new CmdError(feature.getName() + " " + setting.getName() + " is not a BlockList setting.");
        }
        return (BlockListSetting)setting;
    }
}

