/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.util.chunk;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_291;
import net.minecraft.class_8555;
import net.minecraft.class_9801;
import net.wurstclient.events.PacketInputListener;
import net.wurstclient.settings.ChunkAreaSetting;
import net.wurstclient.util.chunk.AbstractChunkCoordinator;
import net.wurstclient.util.chunk.ChunkSearcher;
import net.wurstclient.util.chunk.ChunkUtils;

public final class ChunkVertexBufferCoordinator
extends AbstractChunkCoordinator {
    private final HashMap<class_1923, class_291> buffers = new HashMap();
    private final BiFunction<ChunkSearcher, Iterable<ChunkSearcher.Result>, class_9801> renderer;

    public ChunkVertexBufferCoordinator(BiPredicate<class_2338, class_2680> query, BiFunction<ChunkSearcher, Iterable<ChunkSearcher.Result>, class_9801> renderer, ChunkAreaSetting area) {
        super(query, area);
        this.renderer = Objects.requireNonNull(renderer);
    }

    @Override
    public void onReceivedPacket(PacketInputListener.PacketInputEvent event) {
        class_1923 center = ChunkUtils.getAffectedChunk(event.getPacket());
        if (center == null) {
            return;
        }
        for (int x = center.field_9181 - 1; x <= center.field_9181 + 1; ++x) {
            for (int z = center.field_9180 - 1; z <= center.field_9180 + 1; ++z) {
                this.chunksToUpdate.add(new class_1923(x, z));
            }
        }
    }

    @Override
    protected void onRemove(ChunkSearcher searcher) {
        class_291 buffer = this.buffers.remove(searcher.getPos());
        if (buffer != null) {
            buffer.close();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.buffers.values().forEach(class_291::close);
        this.buffers.clear();
    }

    public Set<Map.Entry<class_1923, class_291>> getBuffers() {
        for (ChunkSearcher searcher : this.searchers.values()) {
            this.buildBuffer(searcher);
        }
        return Collections.unmodifiableSet(this.buffers.entrySet());
    }

    private void buildBuffer(ChunkSearcher searcher) {
        if (this.buffers.containsKey(searcher.getPos())) {
            return;
        }
        class_9801 buffer = this.renderer.apply(searcher, searcher.getMatchesList());
        if (buffer == null) {
            return;
        }
        class_291 vertexBuffer = new class_291(class_8555.field_54340);
        vertexBuffer.method_1353();
        vertexBuffer.method_1352(buffer);
        class_291.method_1354();
        this.buffers.put(searcher.getPos(), vertexBuffer);
    }
}

