/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.analytics;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import net.wurstclient.analytics.WurstAnalyticsTracker;
import net.wurstclient.analytics.dmurph.VisitorData;
import net.wurstclient.util.json.JsonException;
import net.wurstclient.util.json.JsonUtils;
import net.wurstclient.util.json.WsonObject;

public final class AnalyticsConfigFile {
    private final Path path;

    public AnalyticsConfigFile(Path path) {
        this.path = path;
    }

    public void load(WurstAnalyticsTracker tracker) {
        try {
            WsonObject wson = JsonUtils.parseFileToObject(this.path);
            tracker.setEnabled(wson.getBoolean("enabled"));
            tracker.getConfigData().setVisitorData(this.readVisitorData(wson));
        }
        catch (NoSuchFileException wson) {
        }
        catch (IOException | JsonException e) {
            System.out.println("Couldn't load " + String.valueOf(this.path.getFileName()));
            e.printStackTrace();
        }
        this.save(tracker);
    }

    private VisitorData readVisitorData(WsonObject wson) throws JsonException {
        int launches;
        long lastLaunch;
        long firstLaunch;
        int visitorID = wson.getInt("id");
        VisitorData visitorData = VisitorData.newSession(visitorID, firstLaunch = wson.getLong("first_launch"), lastLaunch = wson.getLong("last_launch"), launches = wson.getInt("launches"));
        if (visitorData.getTimestampCurrent() - visitorData.getTimestampFirst() >= 259200L) {
            visitorData = VisitorData.newVisitor();
        }
        return visitorData;
    }

    public void save(WurstAnalyticsTracker tracker) {
        JsonObject json = this.createJson(tracker);
        try {
            JsonUtils.toJson((JsonElement)json, this.path);
        }
        catch (IOException | JsonException e) {
            System.out.println("Couldn't save " + String.valueOf(this.path.getFileName()));
            e.printStackTrace();
        }
    }

    private JsonObject createJson(WurstAnalyticsTracker tracker) {
        JsonObject json = new JsonObject();
        json.addProperty("enabled", Boolean.valueOf(tracker.isEnabled()));
        VisitorData visitorData = tracker.getConfigData().getVisitorData();
        json.addProperty("id", (Number)visitorData.getVisitorId());
        json.addProperty("first_launch", (Number)visitorData.getTimestampFirst());
        json.addProperty("last_launch", (Number)visitorData.getTimestampCurrent());
        json.addProperty("launches", (Number)visitorData.getVisits());
        return json;
    }
}

