/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.commands;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2596;
import net.minecraft.class_2873;
import net.minecraft.class_746;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.wurstclient.command.CmdError;
import net.wurstclient.command.CmdException;
import net.wurstclient.command.CmdSyntaxError;
import net.wurstclient.command.Command;
import net.wurstclient.util.ChatUtils;

public final class ModifyCmd
extends Command {
    public ModifyCmd() {
        super("modify", "Allows you to modify NBT data of items.", ".modify add <nbt_data>", ".modify set <nbt_data>", ".modify remove <nbt_path>", "Use $ for colors, use $$ for $.", "", "Example:", ".modify add {display:{Name:'{\"text\":\"$cRed Name\"}'}}", "(changes the item's name to \u00a7cRed Name\u00a7r)");
    }

    @Override
    public void call(String[] args) throws CmdException {
        class_746 player = ModifyCmd.MC.field_1724;
        if (!player.method_31549().field_7477) {
            throw new CmdError("Creative mode only.");
        }
        if (args.length < 2) {
            throw new CmdSyntaxError();
        }
        class_1799 stack = player.method_31548().method_7391();
        if (stack == null) {
            throw new CmdError("You must hold an item in your main hand.");
        }
        switch (args[0].toLowerCase()) {
            case "add": {
                this.add(stack, args);
                break;
            }
            case "set": {
                this.set(stack, args);
                break;
            }
            case "remove": {
                this.remove(stack, args);
                break;
            }
            default: {
                throw new CmdSyntaxError();
            }
        }
        ModifyCmd.MC.field_1724.field_3944.method_52787((class_2596)new class_2873(36 + player.method_31548().field_7545, stack));
        ChatUtils.message("Item modified.");
    }

    private void add(class_1799 stack, String[] args) throws CmdError {
        String nbtString = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length)).replace("$", "\u00a7").replace("\u00a7\u00a7", "$");
        class_2487 itemNbt = ((class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        try {
            class_2487 parsedNbt = class_2522.method_10718((String)nbtString);
            itemNbt.method_10543(parsedNbt);
            stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)itemNbt));
        }
        catch (CommandSyntaxException e) {
            ChatUtils.message(e.getMessage());
            throw new CmdError("NBT data is invalid.");
        }
    }

    private void set(class_1799 stack, String[] args) throws CmdError {
        String nbt = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        nbt = nbt.replace("$", "\u00a7").replace("\u00a7\u00a7", "$");
        try {
            class_2487 tag = class_2522.method_10718((String)nbt);
            stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
        }
        catch (CommandSyntaxException e) {
            ChatUtils.message(e.getMessage());
            throw new CmdError("NBT data is invalid.");
        }
    }

    private void remove(class_1799 stack, String[] args) throws CmdException {
        if (args.length > 2) {
            throw new CmdSyntaxError();
        }
        NbtPath path = this.parseNbtPath(((class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461(), args[1]);
        if (path == null) {
            throw new CmdError("The path does not exist.");
        }
        path.base.method_10551(path.key);
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)path.base));
    }

    private NbtPath parseNbtPath(class_2487 tag, String path) {
        String[] parts = path.split("\\.");
        class_2487 base = tag;
        if (base == null) {
            return null;
        }
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            if (!base.method_10545(part) || !(base.method_10580(part) instanceof class_2487)) {
                return null;
            }
            base = base.method_10562(part);
        }
        if (!base.method_10545(parts[parts.length - 1])) {
            return null;
        }
        return new NbtPath(base, parts[parts.length - 1]);
    }

    private static class NbtPath {
        public class_2487 base;
        public String key;

        public NbtPath(class_2487 base, String key) {
            this.base = base;
            this.key = key;
        }
    }
}

