/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.util;

import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.wurstclient.settings.FileSetting;
import net.wurstclient.util.json.JsonException;
import net.wurstclient.util.json.JsonUtils;
import net.wurstclient.util.json.WsonObject;

public final class AutoBuildTemplate {
    private final Path path;
    private final String name;
    private final int[][] blocks;

    private AutoBuildTemplate(Path path, int[][] blocks) {
        this.path = path;
        String fileName = path.getFileName().toString();
        this.name = fileName.substring(0, fileName.lastIndexOf("."));
        this.blocks = blocks;
    }

    public static AutoBuildTemplate load(Path path) throws IOException, JsonException {
        WsonObject json = JsonUtils.parseFileToObject(path);
        int[][] blocks = (int[][])JsonUtils.GSON.fromJson(json.getElement("blocks"), int[][].class);
        if (blocks == null) {
            throw new JsonException("Template has no blocks!");
        }
        for (int i = 0; i < blocks.length; ++i) {
            int length = blocks[i].length;
            if (length >= 3) continue;
            throw new JsonException("Entry blocks[" + i + "] doesn't have X, Y and Z offset. Only found " + length + " values");
        }
        return new AutoBuildTemplate(path, blocks);
    }

    public LinkedHashSet<class_2338> getPositions(class_2338 startPos, class_2350 direction) {
        class_2350 front = direction;
        class_2350 left = front.method_10160();
        LinkedHashSet<class_2338> positions = new LinkedHashSet<class_2338>();
        for (int[] block : this.blocks) {
            class_2338 pos = startPos;
            pos = pos.method_10079(left, block[0]);
            pos = pos.method_10086(block[1]);
            pos = pos.method_10079(front, block[2]);
            positions.add(pos);
        }
        return positions;
    }

    public int size() {
        return this.blocks.length;
    }

    public boolean isSelected(FileSetting setting) {
        return this.path.equals(setting.getSelectedFile());
    }

    public Path getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public int[][] getBlocks() {
        return this.blocks;
    }
}

